// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Schema of the Data property of an EventGridEvent for a Microsoft.MachineLearningServices.RunStatusChanged event. */
@Fluent
public final class MachineLearningServicesRunStatusChangedEventData {
    /*
     * The ID of the experiment that the Machine Learning Run belongs to.
     */
    @JsonProperty(value = "experimentId")
    private String experimentId;

    /*
     * The name of the experiment that the Machine Learning Run belongs to.
     */
    @JsonProperty(value = "experimentName")
    private String experimentName;

    /*
     * The ID of the Machine Learning Run.
     */
    @JsonProperty(value = "runId")
    private String runId;

    /*
     * The Run Type of the Machine Learning Run.
     */
    @JsonProperty(value = "runType")
    private String runType;

    /*
     * The tags of the Machine Learning Run.
     */
    @JsonProperty(value = "runTags")
    private Object runTags;

    /*
     * The properties of the Machine Learning Run.
     */
    @JsonProperty(value = "runProperties")
    private Object runProperties;

    /*
     * The status of the Machine Learning Run.
     */
    @JsonProperty(value = "runStatus")
    private String runStatus;

    /** Creates an instance of MachineLearningServicesRunStatusChangedEventData class. */
    public MachineLearningServicesRunStatusChangedEventData() {}

    /**
     * Get the experimentId property: The ID of the experiment that the Machine Learning Run belongs to.
     *
     * @return the experimentId value.
     */
    public String getExperimentId() {
        return this.experimentId;
    }

    /**
     * Set the experimentId property: The ID of the experiment that the Machine Learning Run belongs to.
     *
     * @param experimentId the experimentId value to set.
     * @return the MachineLearningServicesRunStatusChangedEventData object itself.
     */
    public MachineLearningServicesRunStatusChangedEventData setExperimentId(String experimentId) {
        this.experimentId = experimentId;
        return this;
    }

    /**
     * Get the experimentName property: The name of the experiment that the Machine Learning Run belongs to.
     *
     * @return the experimentName value.
     */
    public String getExperimentName() {
        return this.experimentName;
    }

    /**
     * Set the experimentName property: The name of the experiment that the Machine Learning Run belongs to.
     *
     * @param experimentName the experimentName value to set.
     * @return the MachineLearningServicesRunStatusChangedEventData object itself.
     */
    public MachineLearningServicesRunStatusChangedEventData setExperimentName(String experimentName) {
        this.experimentName = experimentName;
        return this;
    }

    /**
     * Get the runId property: The ID of the Machine Learning Run.
     *
     * @return the runId value.
     */
    public String getRunId() {
        return this.runId;
    }

    /**
     * Set the runId property: The ID of the Machine Learning Run.
     *
     * @param runId the runId value to set.
     * @return the MachineLearningServicesRunStatusChangedEventData object itself.
     */
    public MachineLearningServicesRunStatusChangedEventData setRunId(String runId) {
        this.runId = runId;
        return this;
    }

    /**
     * Get the runType property: The Run Type of the Machine Learning Run.
     *
     * @return the runType value.
     */
    public String getRunType() {
        return this.runType;
    }

    /**
     * Set the runType property: The Run Type of the Machine Learning Run.
     *
     * @param runType the runType value to set.
     * @return the MachineLearningServicesRunStatusChangedEventData object itself.
     */
    public MachineLearningServicesRunStatusChangedEventData setRunType(String runType) {
        this.runType = runType;
        return this;
    }

    /**
     * Get the runTags property: The tags of the Machine Learning Run.
     *
     * @return the runTags value.
     */
    public Object getRunTags() {
        return this.runTags;
    }

    /**
     * Set the runTags property: The tags of the Machine Learning Run.
     *
     * @param runTags the runTags value to set.
     * @return the MachineLearningServicesRunStatusChangedEventData object itself.
     */
    public MachineLearningServicesRunStatusChangedEventData setRunTags(Object runTags) {
        this.runTags = runTags;
        return this;
    }

    /**
     * Get the runProperties property: The properties of the Machine Learning Run.
     *
     * @return the runProperties value.
     */
    public Object getRunProperties() {
        return this.runProperties;
    }

    /**
     * Set the runProperties property: The properties of the Machine Learning Run.
     *
     * @param runProperties the runProperties value to set.
     * @return the MachineLearningServicesRunStatusChangedEventData object itself.
     */
    public MachineLearningServicesRunStatusChangedEventData setRunProperties(Object runProperties) {
        this.runProperties = runProperties;
        return this;
    }

    /**
     * Get the runStatus property: The status of the Machine Learning Run.
     *
     * @return the runStatus value.
     */
    public String getRunStatus() {
        return this.runStatus;
    }

    /**
     * Set the runStatus property: The status of the Machine Learning Run.
     *
     * @param runStatus the runStatus value to set.
     * @return the MachineLearningServicesRunStatusChangedEventData object itself.
     */
    public MachineLearningServicesRunStatusChangedEventData setRunStatus(String runStatus) {
        this.runStatus = runStatus;
        return this;
    }
}
