// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Schema of the Data property of an EventGridEvent for a Geofence event (GeofenceEntered, GeofenceExited,
 * GeofenceResult).
 */
@Fluent
public class MapsGeofenceEventProperties {
    /*
     * Lists of the geometry ID of the geofence which is expired relative to the user time in the request.
     */
    @JsonProperty(value = "expiredGeofenceGeometryId")
    private List<String> expiredGeofenceGeometryId;

    /*
     * Lists the fence geometries that either fully contain the coordinate position or have an overlap with the
     * searchBuffer around the fence.
     */
    @JsonProperty(value = "geometries")
    private List<MapsGeofenceGeometry> geometries;

    /*
     * Lists of the geometry ID of the geofence which is in invalid period relative to the user time in the request.
     */
    @JsonProperty(value = "invalidPeriodGeofenceGeometryId")
    private List<String> invalidPeriodGeofenceGeometryId;

    /*
     * True if at least one event is published to the Azure Maps event subscriber, false if no event is published to
     * the Azure Maps event subscriber.
     */
    @JsonProperty(value = "isEventPublished")
    private Boolean isEventPublished;

    /** Creates an instance of MapsGeofenceEventProperties class. */
    public MapsGeofenceEventProperties() {}

    /**
     * Get the expiredGeofenceGeometryId property: Lists of the geometry ID of the geofence which is expired relative to
     * the user time in the request.
     *
     * @return the expiredGeofenceGeometryId value.
     */
    public List<String> getExpiredGeofenceGeometryId() {
        return this.expiredGeofenceGeometryId;
    }

    /**
     * Set the expiredGeofenceGeometryId property: Lists of the geometry ID of the geofence which is expired relative to
     * the user time in the request.
     *
     * @param expiredGeofenceGeometryId the expiredGeofenceGeometryId value to set.
     * @return the MapsGeofenceEventProperties object itself.
     */
    public MapsGeofenceEventProperties setExpiredGeofenceGeometryId(List<String> expiredGeofenceGeometryId) {
        this.expiredGeofenceGeometryId = expiredGeofenceGeometryId;
        return this;
    }

    /**
     * Get the geometries property: Lists the fence geometries that either fully contain the coordinate position or have
     * an overlap with the searchBuffer around the fence.
     *
     * @return the geometries value.
     */
    public List<MapsGeofenceGeometry> getGeometries() {
        return this.geometries;
    }

    /**
     * Set the geometries property: Lists the fence geometries that either fully contain the coordinate position or have
     * an overlap with the searchBuffer around the fence.
     *
     * @param geometries the geometries value to set.
     * @return the MapsGeofenceEventProperties object itself.
     */
    public MapsGeofenceEventProperties setGeometries(List<MapsGeofenceGeometry> geometries) {
        this.geometries = geometries;
        return this;
    }

    /**
     * Get the invalidPeriodGeofenceGeometryId property: Lists of the geometry ID of the geofence which is in invalid
     * period relative to the user time in the request.
     *
     * @return the invalidPeriodGeofenceGeometryId value.
     */
    public List<String> getInvalidPeriodGeofenceGeometryId() {
        return this.invalidPeriodGeofenceGeometryId;
    }

    /**
     * Set the invalidPeriodGeofenceGeometryId property: Lists of the geometry ID of the geofence which is in invalid
     * period relative to the user time in the request.
     *
     * @param invalidPeriodGeofenceGeometryId the invalidPeriodGeofenceGeometryId value to set.
     * @return the MapsGeofenceEventProperties object itself.
     */
    public MapsGeofenceEventProperties setInvalidPeriodGeofenceGeometryId(
            List<String> invalidPeriodGeofenceGeometryId) {
        this.invalidPeriodGeofenceGeometryId = invalidPeriodGeofenceGeometryId;
        return this;
    }

    /**
     * Get the isEventPublished property: True if at least one event is published to the Azure Maps event subscriber,
     * false if no event is published to the Azure Maps event subscriber.
     *
     * @return the isEventPublished value.
     */
    public Boolean isEventPublished() {
        return this.isEventPublished;
    }

    /**
     * Set the isEventPublished property: True if at least one event is published to the Azure Maps event subscriber,
     * false if no event is published to the Azure Maps event subscriber.
     *
     * @param isEventPublished the isEventPublished value to set.
     * @return the MapsGeofenceEventProperties object itself.
     */
    public MapsGeofenceEventProperties setIsEventPublished(Boolean isEventPublished) {
        this.isEventPublished = isEventPublished;
        return this;
    }
}
