// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Details of JobOutput errors. */
@Immutable
public final class MediaJobError {
    /*
     * Error code describing the error.
     */
    @JsonProperty(value = "code", access = JsonProperty.Access.WRITE_ONLY)
    private MediaJobErrorCode code;

    /*
     * A human-readable language-dependent representation of the error.
     */
    @JsonProperty(value = "message", access = JsonProperty.Access.WRITE_ONLY)
    private String message;

    /*
     * Helps with categorization of errors.
     */
    @JsonProperty(value = "category", access = JsonProperty.Access.WRITE_ONLY)
    private MediaJobErrorCategory category;

    /*
     * Indicates that it may be possible to retry the Job. If retry is unsuccessful, please contact Azure support via
     * Azure Portal.
     */
    @JsonProperty(value = "retry", access = JsonProperty.Access.WRITE_ONLY)
    private MediaJobRetry retry;

    /*
     * An array of details about specific errors that led to this reported error.
     */
    @JsonProperty(value = "details", access = JsonProperty.Access.WRITE_ONLY)
    private List<MediaJobErrorDetail> details;

    /** Creates an instance of MediaJobError class. */
    public MediaJobError() {}

    /**
     * Get the code property: Error code describing the error.
     *
     * @return the code value.
     */
    public MediaJobErrorCode getCode() {
        return this.code;
    }

    /**
     * Get the message property: A human-readable language-dependent representation of the error.
     *
     * @return the message value.
     */
    public String getMessage() {
        return this.message;
    }

    /**
     * Get the category property: Helps with categorization of errors.
     *
     * @return the category value.
     */
    public MediaJobErrorCategory getCategory() {
        return this.category;
    }

    /**
     * Get the retry property: Indicates that it may be possible to retry the Job. If retry is unsuccessful, please
     * contact Azure support via Azure Portal.
     *
     * @return the retry value.
     */
    public MediaJobRetry getRetry() {
        return this.retry;
    }

    /**
     * Get the details property: An array of details about specific errors that led to this reported error.
     *
     * @return the details value.
     */
    public List<MediaJobErrorDetail> getDetails() {
        return this.details;
    }
}
