// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** Schema of the Data property of an EventGridEvent for a Microsoft.Media.JobOutputStateChange event. */
@Fluent
public class MediaJobOutputStateChangeEventData {
    /*
     * The previous state of the Job.
     */
    @JsonProperty(value = "previousState", access = JsonProperty.Access.WRITE_ONLY)
    private MediaJobState previousState;

    /*
     * Gets the output.
     */
    @JsonProperty(value = "output")
    private MediaJobOutput output;

    /*
     * Gets the Job correlation data.
     */
    @JsonProperty(value = "jobCorrelationData")
    private Map<String, String> jobCorrelationData;

    /** Creates an instance of MediaJobOutputStateChangeEventData class. */
    public MediaJobOutputStateChangeEventData() {}

    /**
     * Get the previousState property: The previous state of the Job.
     *
     * @return the previousState value.
     */
    public MediaJobState getPreviousState() {
        return this.previousState;
    }

    /**
     * Get the output property: Gets the output.
     *
     * @return the output value.
     */
    public MediaJobOutput getOutput() {
        return this.output;
    }

    /**
     * Set the output property: Gets the output.
     *
     * @param output the output value to set.
     * @return the MediaJobOutputStateChangeEventData object itself.
     */
    public MediaJobOutputStateChangeEventData setOutput(MediaJobOutput output) {
        this.output = output;
        return this;
    }

    /**
     * Get the jobCorrelationData property: Gets the Job correlation data.
     *
     * @return the jobCorrelationData value.
     */
    public Map<String, String> getJobCorrelationData() {
        return this.jobCorrelationData;
    }

    /**
     * Set the jobCorrelationData property: Gets the Job correlation data.
     *
     * @param jobCorrelationData the jobCorrelationData value to set.
     * @return the MediaJobOutputStateChangeEventData object itself.
     */
    public MediaJobOutputStateChangeEventData setJobCorrelationData(Map<String, String> jobCorrelationData) {
        this.jobCorrelationData = jobCorrelationData;
        return this;
    }
}
