// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Indicates that it may be possible to retry the Job. If retry is unsuccessful, please contact Azure support via Azure
 * Portal.
 */
public enum MediaJobRetry {
    /**
     * Issue needs to be investigated and then the job resubmitted with corrections or retried once the underlying issue
     * has been corrected.
     */
    DO_NOT_RETRY("DoNotRetry"),

    /** Issue may be resolved after waiting for a period of time and resubmitting the same Job. */
    MAY_RETRY("MayRetry");

    /** The actual serialized value for a MediaJobRetry instance. */
    private final String value;

    MediaJobRetry(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a MediaJobRetry instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed MediaJobRetry object, or null if unable to parse.
     */
    @JsonCreator
    public static MediaJobRetry fromString(String value) {
        if (value == null) {
            return null;
        }
        MediaJobRetry[] items = MediaJobRetry.values();
        for (MediaJobRetry item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
