// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** Schema of the Data property of an EventGridEvent for a Microsoft.Media.JobStateChange event. */
@Fluent
public class MediaJobStateChangeEventData {
    /*
     * The previous state of the Job.
     */
    @JsonProperty(value = "previousState", access = JsonProperty.Access.WRITE_ONLY)
    private MediaJobState previousState;

    /*
     * The new state of the Job.
     */
    @JsonProperty(value = "state", access = JsonProperty.Access.WRITE_ONLY)
    private MediaJobState state;

    /*
     * Gets the Job correlation data.
     */
    @JsonProperty(value = "correlationData")
    private Map<String, String> correlationData;

    /** Creates an instance of MediaJobStateChangeEventData class. */
    public MediaJobStateChangeEventData() {}

    /**
     * Get the previousState property: The previous state of the Job.
     *
     * @return the previousState value.
     */
    public MediaJobState getPreviousState() {
        return this.previousState;
    }

    /**
     * Get the state property: The new state of the Job.
     *
     * @return the state value.
     */
    public MediaJobState getState() {
        return this.state;
    }

    /**
     * Get the correlationData property: Gets the Job correlation data.
     *
     * @return the correlationData value.
     */
    public Map<String, String> getCorrelationData() {
        return this.correlationData;
    }

    /**
     * Set the correlationData property: Gets the Job correlation data.
     *
     * @param correlationData the correlationData value to set.
     * @return the MediaJobStateChangeEventData object itself.
     */
    public MediaJobStateChangeEventData setCorrelationData(Map<String, String> correlationData) {
        this.correlationData = correlationData;
        return this;
    }
}
