// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;

/**
 * Channel Archive heartbeat event data. Schema of the data property of an EventGridEvent for a
 * Microsoft.Media.LiveEventChannelArchiveHeartbeat event.
 */
@Immutable
public final class MediaLiveEventChannelArchiveHeartbeatEventData {
    /*
     * Gets the channel latency in ms.
     */
    @JsonProperty(value = "channelLatencyMs", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private String channelLatencyMs;

    /*
     * Gets the latency result code.
     */
    @JsonProperty(value = "latencyResultCode", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private String latencyResultCode;

    static final ClientLogger LOGGER = new ClientLogger(MediaLiveEventChannelArchiveHeartbeatEventData.class);

    /** Creates an instance of MediaLiveEventChannelArchiveHeartbeatEventData class. */
    public MediaLiveEventChannelArchiveHeartbeatEventData() {}

    /**
     * Gets the duration of channel latency.
     *
     * @return the duration of channel latency.
     */
    public Duration getChannelLatency() {
        if ("n/a".equals(this.channelLatencyMs)) {
            return null;
        }
        Long channelLatencyMsLong;
        try {
            channelLatencyMsLong = Long.parseLong(this.channelLatencyMs);
        } catch (NumberFormatException ex) {
            LOGGER.logExceptionAsError(ex);
            return null;
        }
        return Duration.ofMillis(channelLatencyMsLong);
    }

    /**
     * Get the latencyResultCode property: Gets the latency result code.
     *
     * @return the latencyResultCode value.
     */
    public String getLatencyResultCode() {
        return this.latencyResultCode;
    }
}
