// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Incoming video stream out of sync event data. Schema of the data property of an EventGridEvent for a
 * Microsoft.Media.LiveEventIncomingVideoStreamsOutOfSync event.
 */
@Immutable
public final class MediaLiveEventIncomingVideoStreamsOutOfSyncEventData {
    /*
     * Gets the first timestamp received for one of the quality levels.
     */
    @JsonProperty(value = "firstTimestamp", access = JsonProperty.Access.WRITE_ONLY)
    private String firstTimestamp;

    /*
     * Gets the duration of the data chunk with first timestamp.
     */
    @JsonProperty(value = "firstDuration", access = JsonProperty.Access.WRITE_ONLY)
    private String firstDuration;

    /*
     * Gets the timestamp received for some other quality levels.
     */
    @JsonProperty(value = "secondTimestamp", access = JsonProperty.Access.WRITE_ONLY)
    private String secondTimestamp;

    /*
     * Gets the duration of the data chunk with second timestamp.
     */
    @JsonProperty(value = "secondDuration", access = JsonProperty.Access.WRITE_ONLY)
    private String secondDuration;

    /*
     * Gets the timescale in which both the timestamps and durations are represented.
     */
    @JsonProperty(value = "timescale", access = JsonProperty.Access.WRITE_ONLY)
    private String timescale;

    /** Creates an instance of MediaLiveEventIncomingVideoStreamsOutOfSyncEventData class. */
    public MediaLiveEventIncomingVideoStreamsOutOfSyncEventData() {}

    /**
     * Get the firstTimestamp property: Gets the first timestamp received for one of the quality levels.
     *
     * @return the firstTimestamp value.
     */
    public String getFirstTimestamp() {
        return this.firstTimestamp;
    }

    /**
     * Get the firstDuration property: Gets the duration of the data chunk with first timestamp.
     *
     * @return the firstDuration value.
     */
    public String getFirstDuration() {
        return this.firstDuration;
    }

    /**
     * Get the secondTimestamp property: Gets the timestamp received for some other quality levels.
     *
     * @return the secondTimestamp value.
     */
    public String getSecondTimestamp() {
        return this.secondTimestamp;
    }

    /**
     * Get the secondDuration property: Gets the duration of the data chunk with second timestamp.
     *
     * @return the secondDuration value.
     */
    public String getSecondDuration() {
        return this.secondDuration;
    }

    /**
     * Get the timescale property: Gets the timescale in which both the timestamps and durations are represented.
     *
     * @return the timescale value.
     */
    public String getTimescale() {
        return this.timescale;
    }
}
