// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Resources.ResourceDeleteSuccess event. This is
 * raised when a resource delete operation succeeds.
 */
@Fluent
public final class ResourceDeleteSuccessEventData {
    /*
     * The tenant ID of the resource.
     */
    @JsonProperty(value = "tenantId")
    private String tenantId;

    /*
     * The subscription ID of the resource.
     */
    @JsonProperty(value = "subscriptionId")
    private String subscriptionId;

    /*
     * The resource group of the resource.
     */
    @JsonProperty(value = "resourceGroup")
    private String resourceGroup;

    /*
     * The resource provider performing the operation.
     */
    @JsonProperty(value = "resourceProvider")
    private String resourceProvider;

    /*
     * The URI of the resource in the operation.
     */
    @JsonProperty(value = "resourceUri")
    private String resourceUri;

    /*
     * The operation that was performed.
     */
    @JsonProperty(value = "operationName")
    private String operationName;

    /*
     * The status of the operation.
     */
    @JsonProperty(value = "status")
    private String status;

    /*
     * The requested authorization for the operation.
     */
    @JsonProperty(value = "authorization")
    private ResourceAuthorization authorization;

    /*
     * The properties of the claims.
     */
    @JsonProperty(value = "claims")
    private Map<String, String> claims;

    /*
     * An operation ID used for troubleshooting.
     */
    @JsonProperty(value = "correlationId")
    private String correlationId;

    /*
     * The details of the operation.
     */
    @JsonProperty(value = "httpRequest")
    private ResourceHttpRequest httpRequest;

    static final SerializerAdapter DEFAULT_SERIALIZER_ADAPTER = JacksonAdapter.createDefaultSerializerAdapter();

    static final ClientLogger LOGGER = new ClientLogger(ResourceDeleteSuccessEventData.class);

    /** Creates an instance of ResourceDeleteSuccessEventData class. */
    public ResourceDeleteSuccessEventData() {}

    /**
     * Get the tenantId property: The tenant ID of the resource.
     *
     * @return the tenantId value.
     */
    public String getTenantId() {
        return this.tenantId;
    }

    /**
     * Set the tenantId property: The tenant ID of the resource.
     *
     * @param tenantId the tenantId value to set.
     * @return the ResourceDeleteSuccessEventData object itself.
     */
    public ResourceDeleteSuccessEventData setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * Get the subscriptionId property: The subscription ID of the resource.
     *
     * @return the subscriptionId value.
     */
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Set the subscriptionId property: The subscription ID of the resource.
     *
     * @param subscriptionId the subscriptionId value to set.
     * @return the ResourceDeleteSuccessEventData object itself.
     */
    public ResourceDeleteSuccessEventData setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    /**
     * Get the resourceGroup property: The resource group of the resource.
     *
     * @return the resourceGroup value.
     */
    public String getResourceGroup() {
        return this.resourceGroup;
    }

    /**
     * Set the resourceGroup property: The resource group of the resource.
     *
     * @param resourceGroup the resourceGroup value to set.
     * @return the ResourceDeleteSuccessEventData object itself.
     */
    public ResourceDeleteSuccessEventData setResourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
        return this;
    }

    /**
     * Get the resourceProvider property: The resource provider performing the operation.
     *
     * @return the resourceProvider value.
     */
    public String getResourceProvider() {
        return this.resourceProvider;
    }

    /**
     * Set the resourceProvider property: The resource provider performing the operation.
     *
     * @param resourceProvider the resourceProvider value to set.
     * @return the ResourceDeleteSuccessEventData object itself.
     */
    public ResourceDeleteSuccessEventData setResourceProvider(String resourceProvider) {
        this.resourceProvider = resourceProvider;
        return this;
    }

    /**
     * Get the resourceUri property: The URI of the resource in the operation.
     *
     * @return the resourceUri value.
     */
    public String getResourceUri() {
        return this.resourceUri;
    }

    /**
     * Set the resourceUri property: The URI of the resource in the operation.
     *
     * @param resourceUri the resourceUri value to set.
     * @return the ResourceDeleteSuccessEventData object itself.
     */
    public ResourceDeleteSuccessEventData setResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
        return this;
    }

    /**
     * Get the operationName property: The operation that was performed.
     *
     * @return the operationName value.
     */
    public String getOperationName() {
        return this.operationName;
    }

    /**
     * Set the operationName property: The operation that was performed.
     *
     * @param operationName the operationName value to set.
     * @return the ResourceDeleteSuccessEventData object itself.
     */
    public ResourceDeleteSuccessEventData setOperationName(String operationName) {
        this.operationName = operationName;
        return this;
    }

    /**
     * Get the status property: The status of the operation.
     *
     * @return the status value.
     */
    public String getStatus() {
        return this.status;
    }

    /**
     * Set the status property: The status of the operation.
     *
     * @param status the status value to set.
     * @return the ResourceDeleteSuccessEventData object itself.
     */
    public ResourceDeleteSuccessEventData setStatus(String status) {
        this.status = status;
        return this;
    }

    /**
     * Get the authorization property: The requested authorization for the operation.
     *
     * @return the authorization value.
     */
    public ResourceAuthorization getResourceAuthorization() {
        return this.authorization;
    }

    /**
     * Set the authorization property: The requested authorization for the operation.
     *
     * @param authorization the authorization value to set.
     * @return the ResourceDeleteSuccessEventData object itself.
     */
    public ResourceDeleteSuccessEventData setResourceAuthorization(ResourceAuthorization authorization) {
        this.authorization = authorization;
        return this;
    }

    /**
     * Get the claims property: The properties of the claims.
     *
     * @return the claims value.
     */
    public Map<String, String> getResourceClaims() {
        return this.claims;
    }

    /**
     * Set the claims property: The properties of the claims.
     *
     * @param claims the claims value to set.
     * @return the ResourceDeleteSuccessEventData object itself.
     */
    public ResourceDeleteSuccessEventData setResourceClaims(Map<String, String> claims) {
        this.claims = claims;
        return this;
    }

    /**
     * Get the correlationId property: An operation ID used for troubleshooting.
     *
     * @return the correlationId value.
     */
    public String getCorrelationId() {
        return this.correlationId;
    }

    /**
     * Set the correlationId property: An operation ID used for troubleshooting.
     *
     * @param correlationId the correlationId value to set.
     * @return the ResourceDeleteSuccessEventData object itself.
     */
    public ResourceDeleteSuccessEventData setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    /**
     * Get the httpRequest property: The details of the operation.
     *
     * @return the httpRequest value.
     */
    public ResourceHttpRequest getResourceHttpRequest() {
        return this.httpRequest;
    }

    /**
     * Set the httpRequest property: The details of the operation.
     *
     * @param httpRequest the httpRequest value to set.
     * @return the ResourceDeleteSuccessEventData object itself.
     */
    public ResourceDeleteSuccessEventData setResourceHttpRequest(ResourceHttpRequest httpRequest) {
        this.httpRequest = httpRequest;
        return this;
    }

    /**
     * Get the claims property: The properties of the claims.
     *
     * @return the claims value.
     * @deprecated This method is no longer supported since v4.9.0.
     *     <p>Use {@link ResourceDeleteSuccessEventData#getResourceClaims()} instead.
     */
    @Deprecated
    public String getClaims() {
        final Map<String, String> resourceClaims = getResourceClaims();
        if (!resourceClaims.isEmpty()) {
            try {
                return DEFAULT_SERIALIZER_ADAPTER.serialize(resourceClaims, SerializerEncoding.JSON);
            } catch (IOException ex) {
                throw LOGGER.logExceptionAsError(new UncheckedIOException(ex));
            }
        }
        return null;
    }

    /**
     * Set the claims property: The properties of the claims.
     *
     * @param claims the claims value to set.
     * @return the ResourceDeleteSuccessEventData object itself.
     * @deprecated This method is no longer supported since v4.9.0.
     *     <p>Use {@link ResourceDeleteSuccessEventData#setResourceClaims(Map)} instead.
     */
    @Deprecated
    public ResourceDeleteSuccessEventData setClaims(String claims) {
        try {
            setResourceClaims(DEFAULT_SERIALIZER_ADAPTER.deserialize(claims, Map.class, SerializerEncoding.JSON));
        } catch (IOException ex) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(ex));
        }
        return this;
    }

    /**
     * Get the httpRequest property: The details of the operation.
     *
     * @return the httpRequest value.
     * @deprecated This method is no longer supported since v4.9.0.
     *     <p>Use {@link ResourceDeleteSuccessEventData#getResourceHttpRequest()} instead.
     */
    @Deprecated
    public String getHttpRequest() {
        ResourceHttpRequest resourceHttpRequest = getResourceHttpRequest();
        try {
            return DEFAULT_SERIALIZER_ADAPTER.serialize(resourceHttpRequest, SerializerEncoding.JSON);
        } catch (IOException ex) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(ex));
        }
    }

    /**
     * Set the httpRequest property: The details of the operation.
     *
     * @param httpRequest the httpRequest value to set.
     * @return the ResourceDeleteSuccessEventData object itself.
     * @deprecated This method is no longer supported since v4.9.0.
     *     <p>Use {@link ResourceDeleteSuccessEventData#setResourceHttpRequest(ResourceHttpRequest)} instead.
     */
    @Deprecated
    public ResourceDeleteSuccessEventData setHttpRequest(String httpRequest) {
        try {
            setResourceHttpRequest(
                    DEFAULT_SERIALIZER_ADAPTER.deserialize(
                            httpRequest, ResourceHttpRequest.class, SerializerEncoding.JSON));
        } catch (IOException ex) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(ex));
        }
        return this;
    }

    /**
     * Get the authorization property: The requested authorization for the operation.
     *
     * @return the authorization value.
     * @deprecated This method is no longer supported since v4.9.0.
     *     <p>Use {@link ResourceDeleteSuccessEventData#getResourceAuthorization()} instead.
     */
    @Deprecated
    public String getAuthorization() {
        final ResourceAuthorization resourceAuthorization = getResourceAuthorization();
        try {
            return DEFAULT_SERIALIZER_ADAPTER.serialize(resourceAuthorization, SerializerEncoding.JSON);
        } catch (IOException ex) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(ex));
        }
    }

    /**
     * Set the authorization property: The requested authorization for the operation.
     *
     * @param authorization the authorization value to set.
     * @return the ResourceDeleteSuccessEventData object itself.
     * @deprecated This method is no longer supported since v4.9.0.
     *     <p>Use {@link ResourceDeleteSuccessEventData#setResourceAuthorization(ResourceAuthorization)} instead.
     */
    @Deprecated
    public ResourceDeleteSuccessEventData setAuthorization(String authorization) {
        try {
            setResourceAuthorization(
                    DEFAULT_SERIALIZER_ADAPTER.deserialize(
                            authorization, ResourceAuthorization.class, SerializerEncoding.JSON));
        } catch (IOException ex) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(ex));
        }
        return this;
    }
}
