// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Execution statistics of a specific policy action in a Blob Management cycle. */
@Fluent
public final class StorageLifecyclePolicyActionSummaryDetail {
    /*
     * Total number of objects to be acted on by this action.
     */
    @JsonProperty(value = "totalObjectsCount")
    private Long totalObjectsCount;

    /*
     * Number of success operations of this action.
     */
    @JsonProperty(value = "successCount")
    private Long successCount;

    /*
     * Error messages of this action if any.
     */
    @JsonProperty(value = "errorList")
    private String errorList;

    /** Creates an instance of StorageLifecyclePolicyActionSummaryDetail class. */
    public StorageLifecyclePolicyActionSummaryDetail() {}

    /**
     * Get the totalObjectsCount property: Total number of objects to be acted on by this action.
     *
     * @return the totalObjectsCount value.
     */
    public Long getTotalObjectsCount() {
        return this.totalObjectsCount;
    }

    /**
     * Set the totalObjectsCount property: Total number of objects to be acted on by this action.
     *
     * @param totalObjectsCount the totalObjectsCount value to set.
     * @return the StorageLifecyclePolicyActionSummaryDetail object itself.
     */
    public StorageLifecyclePolicyActionSummaryDetail setTotalObjectsCount(Long totalObjectsCount) {
        this.totalObjectsCount = totalObjectsCount;
        return this;
    }

    /**
     * Get the successCount property: Number of success operations of this action.
     *
     * @return the successCount value.
     */
    public Long getSuccessCount() {
        return this.successCount;
    }

    /**
     * Set the successCount property: Number of success operations of this action.
     *
     * @param successCount the successCount value to set.
     * @return the StorageLifecyclePolicyActionSummaryDetail object itself.
     */
    public StorageLifecyclePolicyActionSummaryDetail setSuccessCount(Long successCount) {
        this.successCount = successCount;
        return this;
    }

    /**
     * Get the errorList property: Error messages of this action if any.
     *
     * @return the errorList value.
     */
    public String getErrorList() {
        return this.errorList;
    }

    /**
     * Set the errorList property: Error messages of this action if any.
     *
     * @param errorList the errorList value to set.
     * @return the StorageLifecyclePolicyActionSummaryDetail object itself.
     */
    public StorageLifecyclePolicyActionSummaryDetail setErrorList(String errorList) {
        this.errorList = errorList;
        return this;
    }
}
