// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Schema of the Data property of an EventGridEvent for a Microsoft.Storage.LifecyclePolicyCompleted event. */
@Fluent
public final class StorageLifecyclePolicyCompletedEventData {
    /*
     * The time the policy task was scheduled.
     */
    @JsonProperty(value = "scheduleTime")
    private String scheduleTime;

    /*
     * Execution statistics of a specific policy action in a Blob Management cycle.
     */
    @JsonProperty(value = "deleteSummary")
    private StorageLifecyclePolicyActionSummaryDetail deleteSummary;

    /*
     * Execution statistics of a specific policy action in a Blob Management cycle.
     */
    @JsonProperty(value = "tierToCoolSummary")
    private StorageLifecyclePolicyActionSummaryDetail tierToCoolSummary;

    /*
     * Execution statistics of a specific policy action in a Blob Management cycle.
     */
    @JsonProperty(value = "tierToArchiveSummary")
    private StorageLifecyclePolicyActionSummaryDetail tierToArchiveSummary;

    /** Creates an instance of StorageLifecyclePolicyCompletedEventData class. */
    public StorageLifecyclePolicyCompletedEventData() {}

    /**
     * Get the scheduleTime property: The time the policy task was scheduled.
     *
     * @return the scheduleTime value.
     */
    public String getScheduleTime() {
        return this.scheduleTime;
    }

    /**
     * Set the scheduleTime property: The time the policy task was scheduled.
     *
     * @param scheduleTime the scheduleTime value to set.
     * @return the StorageLifecyclePolicyCompletedEventData object itself.
     */
    public StorageLifecyclePolicyCompletedEventData setScheduleTime(String scheduleTime) {
        this.scheduleTime = scheduleTime;
        return this;
    }

    /**
     * Get the deleteSummary property: Execution statistics of a specific policy action in a Blob Management cycle.
     *
     * @return the deleteSummary value.
     */
    public StorageLifecyclePolicyActionSummaryDetail getDeleteSummary() {
        return this.deleteSummary;
    }

    /**
     * Set the deleteSummary property: Execution statistics of a specific policy action in a Blob Management cycle.
     *
     * @param deleteSummary the deleteSummary value to set.
     * @return the StorageLifecyclePolicyCompletedEventData object itself.
     */
    public StorageLifecyclePolicyCompletedEventData setDeleteSummary(
            StorageLifecyclePolicyActionSummaryDetail deleteSummary) {
        this.deleteSummary = deleteSummary;
        return this;
    }

    /**
     * Get the tierToCoolSummary property: Execution statistics of a specific policy action in a Blob Management cycle.
     *
     * @return the tierToCoolSummary value.
     */
    public StorageLifecyclePolicyActionSummaryDetail getTierToCoolSummary() {
        return this.tierToCoolSummary;
    }

    /**
     * Set the tierToCoolSummary property: Execution statistics of a specific policy action in a Blob Management cycle.
     *
     * @param tierToCoolSummary the tierToCoolSummary value to set.
     * @return the StorageLifecyclePolicyCompletedEventData object itself.
     */
    public StorageLifecyclePolicyCompletedEventData setTierToCoolSummary(
            StorageLifecyclePolicyActionSummaryDetail tierToCoolSummary) {
        this.tierToCoolSummary = tierToCoolSummary;
        return this;
    }

    /**
     * Get the tierToArchiveSummary property: Execution statistics of a specific policy action in a Blob Management
     * cycle.
     *
     * @return the tierToArchiveSummary value.
     */
    public StorageLifecyclePolicyActionSummaryDetail getTierToArchiveSummary() {
        return this.tierToArchiveSummary;
    }

    /**
     * Set the tierToArchiveSummary property: Execution statistics of a specific policy action in a Blob Management
     * cycle.
     *
     * @param tierToArchiveSummary the tierToArchiveSummary value to set.
     * @return the StorageLifecyclePolicyCompletedEventData object itself.
     */
    public StorageLifecyclePolicyCompletedEventData setTierToArchiveSummary(
            StorageLifecyclePolicyActionSummaryDetail tierToArchiveSummary) {
        this.tierToArchiveSummary = tierToArchiveSummary;
        return this;
    }
}
