// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** Schema of the Data property of an EventGridEvent for an Microsoft.Storage.StorageTaskCompleted event. */
@Fluent
public final class StorageTaskCompletedEventData {
    /*
     * The status for a storage task.
     */
    @JsonProperty(value = "status")
    private StorageTaskCompletedStatus status;

    /*
     * The time at which a storage task was completed.
     */
    @JsonProperty(value = "completedDateTime")
    private OffsetDateTime completedDateTime;

    /*
     * The execution id for a storage task.
     */
    @JsonProperty(value = "taskExecutionId")
    private String taskExecutionId;

    /*
     * The task name for a storage task.
     */
    @JsonProperty(value = "taskName")
    private String taskName;

    /*
     * The summary report blob url for a storage task
     */
    @JsonProperty(value = "summaryReportBlobUrl")
    private String summaryReportBlobUrl;

    /** Creates an instance of StorageTaskCompletedEventData class. */
    public StorageTaskCompletedEventData() {}

    /**
     * Get the status property: The status for a storage task.
     *
     * @return the status value.
     */
    public StorageTaskCompletedStatus getStatus() {
        return this.status;
    }

    /**
     * Set the status property: The status for a storage task.
     *
     * @param status the status value to set.
     * @return the StorageTaskCompletedEventData object itself.
     */
    public StorageTaskCompletedEventData setStatus(StorageTaskCompletedStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the completedDateTime property: The time at which a storage task was completed.
     *
     * @return the completedDateTime value.
     */
    public OffsetDateTime getCompletedDateTime() {
        return this.completedDateTime;
    }

    /**
     * Set the completedDateTime property: The time at which a storage task was completed.
     *
     * @param completedDateTime the completedDateTime value to set.
     * @return the StorageTaskCompletedEventData object itself.
     */
    public StorageTaskCompletedEventData setCompletedDateTime(OffsetDateTime completedDateTime) {
        this.completedDateTime = completedDateTime;
        return this;
    }

    /**
     * Get the taskExecutionId property: The execution id for a storage task.
     *
     * @return the taskExecutionId value.
     */
    public String getTaskExecutionId() {
        return this.taskExecutionId;
    }

    /**
     * Set the taskExecutionId property: The execution id for a storage task.
     *
     * @param taskExecutionId the taskExecutionId value to set.
     * @return the StorageTaskCompletedEventData object itself.
     */
    public StorageTaskCompletedEventData setTaskExecutionId(String taskExecutionId) {
        this.taskExecutionId = taskExecutionId;
        return this;
    }

    /**
     * Get the taskName property: The task name for a storage task.
     *
     * @return the taskName value.
     */
    public String getTaskName() {
        return this.taskName;
    }

    /**
     * Set the taskName property: The task name for a storage task.
     *
     * @param taskName the taskName value to set.
     * @return the StorageTaskCompletedEventData object itself.
     */
    public StorageTaskCompletedEventData setTaskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    /**
     * Get the summaryReportBlobUrl property: The summary report blob url for a storage task.
     *
     * @return the summaryReportBlobUrl value.
     */
    public String getSummaryReportBlobUrl() {
        return this.summaryReportBlobUrl;
    }

    /**
     * Set the summaryReportBlobUrl property: The summary report blob url for a storage task.
     *
     * @param summaryReportBlobUrl the summaryReportBlobUrl value to set.
     * @return the StorageTaskCompletedEventData object itself.
     */
    public StorageTaskCompletedEventData setSummaryReportBlobUrl(String summaryReportBlobUrl) {
        this.summaryReportBlobUrl = summaryReportBlobUrl;
        return this;
    }
}
