// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** Schema of the Data property of an EventGridEvent for an Microsoft.Storage.StorageTaskQueued event. */
@Fluent
public final class StorageTaskQueuedEventData {
    /*
     * The time at which a storage task was queued.
     */
    @JsonProperty(value = "queuedDateTime")
    private OffsetDateTime queuedDateTime;

    /*
     * The execution id for a storage task.
     */
    @JsonProperty(value = "taskExecutionId")
    private String taskExecutionId;

    /** Creates an instance of StorageTaskQueuedEventData class. */
    public StorageTaskQueuedEventData() {}

    /**
     * Get the queuedDateTime property: The time at which a storage task was queued.
     *
     * @return the queuedDateTime value.
     */
    public OffsetDateTime getQueuedDateTime() {
        return this.queuedDateTime;
    }

    /**
     * Set the queuedDateTime property: The time at which a storage task was queued.
     *
     * @param queuedDateTime the queuedDateTime value to set.
     * @return the StorageTaskQueuedEventData object itself.
     */
    public StorageTaskQueuedEventData setQueuedDateTime(OffsetDateTime queuedDateTime) {
        this.queuedDateTime = queuedDateTime;
        return this;
    }

    /**
     * Get the taskExecutionId property: The execution id for a storage task.
     *
     * @return the taskExecutionId value.
     */
    public String getTaskExecutionId() {
        return this.taskExecutionId;
    }

    /**
     * Set the taskExecutionId property: The execution id for a storage task.
     *
     * @param taskExecutionId the taskExecutionId value to set.
     * @return the StorageTaskQueuedEventData object itself.
     */
    public StorageTaskQueuedEventData setTaskExecutionId(String taskExecutionId) {
        this.taskExecutionId = taskExecutionId;
        return this;
    }
}
