// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * To complete an event subscription validation handshake, a subscriber can use either the validationCode or the
 * validationUrl received in a SubscriptionValidationEvent. When the validationCode is used, the
 * SubscriptionValidationResponse can be used to build the response.
 */
@Fluent
public final class SubscriptionValidationResponse {
    /*
     * The validation response sent by the subscriber to Azure Event Grid to complete the validation of an event
     * subscription.
     */
    @JsonProperty(value = "validationResponse")
    private String validationResponse;

    /** Creates an instance of SubscriptionValidationResponse class. */
    public SubscriptionValidationResponse() {}

    /**
     * Get the validationResponse property: The validation response sent by the subscriber to Azure Event Grid to
     * complete the validation of an event subscription.
     *
     * @return the validationResponse value.
     */
    public String getValidationResponse() {
        return this.validationResponse;
    }

    /**
     * Set the validationResponse property: The validation response sent by the subscriber to Azure Event Grid to
     * complete the validation of an event subscription.
     *
     * @param validationResponse the validationResponse value to set.
     * @return the SubscriptionValidationResponse object itself.
     */
    public SubscriptionValidationResponse setValidationResponse(String validationResponse) {
        this.validationResponse = validationResponse;
        return this;
    }
}
