// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** sku of app service plan. */
@Fluent
public final class WebAppServicePlanUpdatedEventDataSku {
    /*
     * name of app service plan sku.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * tier of app service plan sku.
     */
    @JsonProperty(value = "Tier")
    private String tier;

    /*
     * size of app service plan sku.
     */
    @JsonProperty(value = "Size")
    private String size;

    /*
     * family of app service plan sku.
     */
    @JsonProperty(value = "Family")
    private String family;

    /*
     * capacity of app service plan sku.
     */
    @JsonProperty(value = "Capacity")
    private String capacity;

    /** Creates an instance of WebAppServicePlanUpdatedEventDataSku class. */
    public WebAppServicePlanUpdatedEventDataSku() {}

    /**
     * Get the name property: name of app service plan sku.
     *
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: name of app service plan sku.
     *
     * @param name the name value to set.
     * @return the WebAppServicePlanUpdatedEventDataSku object itself.
     */
    public WebAppServicePlanUpdatedEventDataSku setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the tier property: tier of app service plan sku.
     *
     * @return the tier value.
     */
    public String getTier() {
        return this.tier;
    }

    /**
     * Set the tier property: tier of app service plan sku.
     *
     * @param tier the tier value to set.
     * @return the WebAppServicePlanUpdatedEventDataSku object itself.
     */
    public WebAppServicePlanUpdatedEventDataSku setTier(String tier) {
        this.tier = tier;
        return this;
    }

    /**
     * Get the size property: size of app service plan sku.
     *
     * @return the size value.
     */
    public String getSize() {
        return this.size;
    }

    /**
     * Set the size property: size of app service plan sku.
     *
     * @param size the size value to set.
     * @return the WebAppServicePlanUpdatedEventDataSku object itself.
     */
    public WebAppServicePlanUpdatedEventDataSku setSize(String size) {
        this.size = size;
        return this;
    }

    /**
     * Get the family property: family of app service plan sku.
     *
     * @return the family value.
     */
    public String getFamily() {
        return this.family;
    }

    /**
     * Set the family property: family of app service plan sku.
     *
     * @param family the family value to set.
     * @return the WebAppServicePlanUpdatedEventDataSku object itself.
     */
    public WebAppServicePlanUpdatedEventDataSku setFamily(String family) {
        this.family = family;
        return this;
    }

    /**
     * Get the capacity property: capacity of app service plan sku.
     *
     * @return the capacity value.
     */
    public String getCapacity() {
        return this.capacity;
    }

    /**
     * Set the capacity property: capacity of app service plan sku.
     *
     * @param capacity the capacity value to set.
     * @return the WebAppServicePlanUpdatedEventDataSku object itself.
     */
    public WebAppServicePlanUpdatedEventDataSku setCapacity(String capacity) {
        this.capacity = capacity;
        return this;
    }
}
