/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.models.CloudEvent;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.messaging.eventgrid.implementation.models.EventGridEvent;
import java.util.List;
import reactor.core.publisher.Mono;

public final class EventGridPublisherClientImpl {
    private final EventGridPublisherClientService service;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    EventGridPublisherClientImpl(String apiVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), apiVersion);
    }

    EventGridPublisherClientImpl(HttpPipeline httpPipeline, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), apiVersion);
    }

    EventGridPublisherClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.apiVersion = apiVersion;
        this.service = (EventGridPublisherClientService)RestProxy.create(EventGridPublisherClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> publishEventGridEventsWithResponseAsync(String topicHostname, List<EventGridEvent> events) {
        return FluxUtil.withContext(context -> this.service.publishEventGridEvents(topicHostname, this.getApiVersion(), events, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> publishEventGridEventsWithResponseAsync(String topicHostname, List<EventGridEvent> events, Context context) {
        return this.service.publishEventGridEvents(topicHostname, this.getApiVersion(), events, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> publishEventGridEventsAsync(String topicHostname, List<EventGridEvent> events) {
        return this.publishEventGridEventsWithResponseAsync(topicHostname, events).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> publishEventGridEventsAsync(String topicHostname, List<EventGridEvent> events, Context context) {
        return this.publishEventGridEventsWithResponseAsync(topicHostname, events, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> publishEventGridEventsWithResponse(String topicHostname, List<EventGridEvent> events, Context context) {
        return this.service.publishEventGridEventsSync(topicHostname, this.getApiVersion(), events, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void publishEventGridEvents(String topicHostname, List<EventGridEvent> events) {
        this.publishEventGridEventsWithResponse(topicHostname, events, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> publishCloudEventEventsWithResponseAsync(String topicHostname, List<CloudEvent> events, String aegChannelName) {
        return FluxUtil.withContext(context -> this.service.publishCloudEventEvents(topicHostname, this.getApiVersion(), aegChannelName, events, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> publishCloudEventEventsWithResponseAsync(String topicHostname, List<CloudEvent> events, String aegChannelName, Context context) {
        return this.service.publishCloudEventEvents(topicHostname, this.getApiVersion(), aegChannelName, events, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> publishCloudEventEventsAsync(String topicHostname, List<CloudEvent> events, String aegChannelName) {
        return this.publishCloudEventEventsWithResponseAsync(topicHostname, events, aegChannelName).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> publishCloudEventEventsAsync(String topicHostname, List<CloudEvent> events, String aegChannelName, Context context) {
        return this.publishCloudEventEventsWithResponseAsync(topicHostname, events, aegChannelName, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> publishCloudEventEventsWithResponse(String topicHostname, List<CloudEvent> events, String aegChannelName, Context context) {
        return this.service.publishCloudEventEventsSync(topicHostname, this.getApiVersion(), aegChannelName, events, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void publishCloudEventEvents(String topicHostname, List<CloudEvent> events, String aegChannelName) {
        this.publishCloudEventEventsWithResponse(topicHostname, events, aegChannelName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> publishCustomEventEventsWithResponseAsync(String topicHostname, List<Object> events) {
        return FluxUtil.withContext(context -> this.service.publishCustomEventEvents(topicHostname, this.getApiVersion(), events, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> publishCustomEventEventsWithResponseAsync(String topicHostname, List<Object> events, Context context) {
        return this.service.publishCustomEventEvents(topicHostname, this.getApiVersion(), events, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> publishCustomEventEventsAsync(String topicHostname, List<Object> events) {
        return this.publishCustomEventEventsWithResponseAsync(topicHostname, events).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> publishCustomEventEventsAsync(String topicHostname, List<Object> events, Context context) {
        return this.publishCustomEventEventsWithResponseAsync(topicHostname, events, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> publishCustomEventEventsWithResponse(String topicHostname, List<Object> events, Context context) {
        return this.service.publishCustomEventEventsSync(topicHostname, this.getApiVersion(), events, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void publishCustomEventEvents(String topicHostname, List<Object> events) {
        this.publishCustomEventEventsWithResponse(topicHostname, events, Context.NONE);
    }

    @Host(value="https://{topicHostname}")
    @ServiceInterface(name="EventGridPublisherCl")
    public static interface EventGridPublisherClientService {
        @Post(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Void>> publishEventGridEvents(@HostParam(value="topicHostname") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") List<EventGridEvent> var3, Context var4);

        @Post(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Response<Void> publishEventGridEventsSync(@HostParam(value="topicHostname") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") List<EventGridEvent> var3, Context var4);

        @Post(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Void>> publishCloudEventEvents(@HostParam(value="topicHostname") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="aeg-channel-name") String var3, @BodyParam(value="application/cloudevents-batch+json; charset=utf-8") List<CloudEvent> var4, Context var5);

        @Post(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Response<Void> publishCloudEventEventsSync(@HostParam(value="topicHostname") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="aeg-channel-name") String var3, @BodyParam(value="application/cloudevents-batch+json; charset=utf-8") List<CloudEvent> var4, Context var5);

        @Post(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Void>> publishCustomEventEvents(@HostParam(value="topicHostname") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") List<Object> var3, Context var4);

        @Post(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Response<Void> publishCustomEventEventsSync(@HostParam(value="topicHostname") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") List<Object> var3, Context var4);
    }
}

