/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.messaging.eventgrid.systemevents.ResourceAuthorization;
import com.azure.messaging.eventgrid.systemevents.ResourceHttpRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;

public final class ResourceWriteCancelEventData {
    @JsonProperty(value="tenantId")
    private String tenantId;
    @JsonProperty(value="subscriptionId")
    private String subscriptionId;
    @JsonProperty(value="resourceGroup")
    private String resourceGroup;
    @JsonProperty(value="resourceProvider")
    private String resourceProvider;
    @JsonProperty(value="resourceUri")
    private String resourceUri;
    @JsonProperty(value="operationName")
    private String operationName;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="authorization")
    private ResourceAuthorization authorization;
    @JsonProperty(value="claims")
    private Map<String, String> claims;
    @JsonProperty(value="correlationId")
    private String correlationId;
    @JsonProperty(value="httpRequest")
    private ResourceHttpRequest httpRequest;
    private static final ClientLogger LOGGER = new ClientLogger(ResourceWriteCancelEventData.class);
    private static final SerializerAdapter DEFAULT_SERIALIZER_ADAPTER = JacksonAdapter.createDefaultSerializerAdapter();

    public String getTenantId() {
        return this.tenantId;
    }

    public ResourceWriteCancelEventData setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public ResourceWriteCancelEventData setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public ResourceWriteCancelEventData setResourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
        return this;
    }

    public String getResourceProvider() {
        return this.resourceProvider;
    }

    public ResourceWriteCancelEventData setResourceProvider(String resourceProvider) {
        this.resourceProvider = resourceProvider;
        return this;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public ResourceWriteCancelEventData setResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
        return this;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public ResourceWriteCancelEventData setOperationName(String operationName) {
        this.operationName = operationName;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public ResourceWriteCancelEventData setStatus(String status) {
        this.status = status;
        return this;
    }

    public ResourceAuthorization getResourceAuthorization() {
        return this.authorization;
    }

    public ResourceWriteCancelEventData setResourceAuthorization(ResourceAuthorization authorization) {
        this.authorization = authorization;
        return this;
    }

    public Map<String, String> getResourceClaims() {
        return this.claims;
    }

    public ResourceWriteCancelEventData setResourceClaims(Map<String, String> claims) {
        this.claims = claims;
        return this;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public ResourceWriteCancelEventData setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    public ResourceHttpRequest getResourceHttpRequest() {
        return this.httpRequest;
    }

    public ResourceWriteCancelEventData setResourceHttpRequest(ResourceHttpRequest httpRequest) {
        this.httpRequest = httpRequest;
        return this;
    }

    @Deprecated
    public String getClaims() {
        Map<String, String> resourceClaims = this.getResourceClaims();
        if (!resourceClaims.isEmpty()) {
            try {
                return DEFAULT_SERIALIZER_ADAPTER.serialize(resourceClaims, SerializerEncoding.JSON);
            }
            catch (IOException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
            }
        }
        return null;
    }

    @Deprecated
    public ResourceWriteCancelEventData setClaims(String claims) {
        try {
            this.setResourceClaims((Map)DEFAULT_SERIALIZER_ADAPTER.deserialize(claims, Map.class, SerializerEncoding.JSON));
        }
        catch (IOException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
        return this;
    }

    @Deprecated
    public String getHttpRequest() {
        ResourceHttpRequest resourceHttpRequest = this.getResourceHttpRequest();
        try {
            return DEFAULT_SERIALIZER_ADAPTER.serialize((Object)resourceHttpRequest, SerializerEncoding.JSON);
        }
        catch (IOException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
    }

    @Deprecated
    public ResourceWriteCancelEventData setHttpRequest(String httpRequest) {
        try {
            this.setResourceHttpRequest((ResourceHttpRequest)DEFAULT_SERIALIZER_ADAPTER.deserialize(httpRequest, ResourceHttpRequest.class, SerializerEncoding.JSON));
        }
        catch (IOException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
        return this;
    }

    @Deprecated
    public String getAuthorization() {
        ResourceAuthorization resourceAuthorization = this.getResourceAuthorization();
        try {
            return DEFAULT_SERIALIZER_ADAPTER.serialize((Object)resourceAuthorization, SerializerEncoding.JSON);
        }
        catch (IOException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
    }

    @Deprecated
    public ResourceWriteCancelEventData setAuthorization(String authorization) {
        try {
            this.setResourceAuthorization((ResourceAuthorization)DEFAULT_SERIALIZER_ADAPTER.deserialize(authorization, ResourceAuthorization.class, SerializerEncoding.JSON));
        }
        catch (IOException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
        return this;
    }
}

