/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsChatMessageEventBaseProperties;
import com.azure.messaging.eventgrid.systemevents.CommunicationIdentifierModel;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class AcsChatMessageEditedEventData
extends AcsChatMessageEventBaseProperties {
    private String messageBody;
    private Map<String, String> metadata;
    private OffsetDateTime editTime;

    public String getMessageBody() {
        return this.messageBody;
    }

    public AcsChatMessageEditedEventData setMessageBody(String messageBody) {
        this.messageBody = messageBody;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public AcsChatMessageEditedEventData setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public OffsetDateTime getEditTime() {
        return this.editTime;
    }

    public AcsChatMessageEditedEventData setEditTime(OffsetDateTime editTime) {
        this.editTime = editTime;
        return this;
    }

    @Override
    public AcsChatMessageEditedEventData setMessageId(String messageId) {
        super.setMessageId(messageId);
        return this;
    }

    @Override
    public AcsChatMessageEditedEventData setSenderCommunicationIdentifier(CommunicationIdentifierModel senderCommunicationIdentifier) {
        super.setSenderCommunicationIdentifier(senderCommunicationIdentifier);
        return this;
    }

    @Override
    public AcsChatMessageEditedEventData setSenderDisplayName(String senderDisplayName) {
        super.setSenderDisplayName(senderDisplayName);
        return this;
    }

    @Override
    public AcsChatMessageEditedEventData setComposeTime(OffsetDateTime composeTime) {
        super.setComposeTime(composeTime);
        return this;
    }

    @Override
    public AcsChatMessageEditedEventData setType(String type) {
        super.setType(type);
        return this;
    }

    @Override
    public AcsChatMessageEditedEventData setVersion(Long version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AcsChatMessageEditedEventData setRecipientCommunicationIdentifier(CommunicationIdentifierModel recipientCommunicationIdentifier) {
        super.setRecipientCommunicationIdentifier(recipientCommunicationIdentifier);
        return this;
    }

    @Override
    public AcsChatMessageEditedEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    @Override
    public AcsChatMessageEditedEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("recipientCommunicationIdentifier", (JsonSerializable)this.getRecipientCommunicationIdentifier());
        jsonWriter.writeStringField("transactionId", this.getTransactionId());
        jsonWriter.writeStringField("threadId", this.getThreadId());
        jsonWriter.writeStringField("messageId", this.getMessageId());
        jsonWriter.writeJsonField("senderCommunicationIdentifier", (JsonSerializable)this.getSenderCommunicationIdentifier());
        jsonWriter.writeStringField("senderDisplayName", this.getSenderDisplayName());
        jsonWriter.writeStringField("composeTime", this.getComposeTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getComposeTime()));
        jsonWriter.writeStringField("type", this.getType());
        jsonWriter.writeNumberField("version", (Number)this.getVersion());
        jsonWriter.writeStringField("messageBody", this.messageBody);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("editTime", this.editTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.editTime));
        return jsonWriter.writeEndObject();
    }

    public static AcsChatMessageEditedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsChatMessageEditedEventData)jsonReader.readObject(reader -> {
            AcsChatMessageEditedEventData deserializedAcsChatMessageEditedEventData = new AcsChatMessageEditedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("recipientCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatMessageEditedEventData.setRecipientCommunicationIdentifier(CommunicationIdentifierModel.fromJson(reader));
                    continue;
                }
                if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatMessageEditedEventData.setTransactionId(reader.getString());
                    continue;
                }
                if ("threadId".equals(fieldName)) {
                    deserializedAcsChatMessageEditedEventData.setThreadId(reader.getString());
                    continue;
                }
                if ("messageId".equals(fieldName)) {
                    deserializedAcsChatMessageEditedEventData.setMessageId(reader.getString());
                    continue;
                }
                if ("senderCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatMessageEditedEventData.setSenderCommunicationIdentifier(CommunicationIdentifierModel.fromJson(reader));
                    continue;
                }
                if ("senderDisplayName".equals(fieldName)) {
                    deserializedAcsChatMessageEditedEventData.setSenderDisplayName(reader.getString());
                    continue;
                }
                if ("composeTime".equals(fieldName)) {
                    deserializedAcsChatMessageEditedEventData.setComposeTime((OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString())));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAcsChatMessageEditedEventData.setType(reader.getString());
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedAcsChatMessageEditedEventData.setVersion((Long)reader.getNullable(JsonReader::getLong));
                    continue;
                }
                if ("messageBody".equals(fieldName)) {
                    deserializedAcsChatMessageEditedEventData.messageBody = reader.getString();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedAcsChatMessageEditedEventData.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("editTime".equals(fieldName)) {
                    deserializedAcsChatMessageEditedEventData.editTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsChatMessageEditedEventData;
        });
    }
}

