/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsChatMessageEventInThreadBaseProperties;
import com.azure.messaging.eventgrid.systemevents.CommunicationIdentifierModel;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class AcsChatMessageReceivedInThreadEventData
extends AcsChatMessageEventInThreadBaseProperties {
    private String messageBody;
    private Map<String, String> metadata;

    public String getMessageBody() {
        return this.messageBody;
    }

    public AcsChatMessageReceivedInThreadEventData setMessageBody(String messageBody) {
        this.messageBody = messageBody;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public AcsChatMessageReceivedInThreadEventData setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public AcsChatMessageReceivedInThreadEventData setMessageId(String messageId) {
        super.setMessageId(messageId);
        return this;
    }

    @Override
    public AcsChatMessageReceivedInThreadEventData setSenderCommunicationIdentifier(CommunicationIdentifierModel senderCommunicationIdentifier) {
        super.setSenderCommunicationIdentifier(senderCommunicationIdentifier);
        return this;
    }

    @Override
    public AcsChatMessageReceivedInThreadEventData setSenderDisplayName(String senderDisplayName) {
        super.setSenderDisplayName(senderDisplayName);
        return this;
    }

    @Override
    public AcsChatMessageReceivedInThreadEventData setComposeTime(OffsetDateTime composeTime) {
        super.setComposeTime(composeTime);
        return this;
    }

    @Override
    public AcsChatMessageReceivedInThreadEventData setType(String type) {
        super.setType(type);
        return this;
    }

    @Override
    public AcsChatMessageReceivedInThreadEventData setVersion(Long version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AcsChatMessageReceivedInThreadEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    @Override
    public AcsChatMessageReceivedInThreadEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("transactionId", this.getTransactionId());
        jsonWriter.writeStringField("threadId", this.getThreadId());
        jsonWriter.writeStringField("messageId", this.getMessageId());
        jsonWriter.writeJsonField("senderCommunicationIdentifier", (JsonSerializable)this.getSenderCommunicationIdentifier());
        jsonWriter.writeStringField("senderDisplayName", this.getSenderDisplayName());
        jsonWriter.writeStringField("composeTime", this.getComposeTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getComposeTime()));
        jsonWriter.writeStringField("type", this.getType());
        jsonWriter.writeNumberField("version", (Number)this.getVersion());
        jsonWriter.writeStringField("messageBody", this.messageBody);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static AcsChatMessageReceivedInThreadEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsChatMessageReceivedInThreadEventData)jsonReader.readObject(reader -> {
            AcsChatMessageReceivedInThreadEventData deserializedAcsChatMessageReceivedInThreadEventData = new AcsChatMessageReceivedInThreadEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedInThreadEventData.setTransactionId(reader.getString());
                    continue;
                }
                if ("threadId".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedInThreadEventData.setThreadId(reader.getString());
                    continue;
                }
                if ("messageId".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedInThreadEventData.setMessageId(reader.getString());
                    continue;
                }
                if ("senderCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedInThreadEventData.setSenderCommunicationIdentifier(CommunicationIdentifierModel.fromJson(reader));
                    continue;
                }
                if ("senderDisplayName".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedInThreadEventData.setSenderDisplayName(reader.getString());
                    continue;
                }
                if ("composeTime".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedInThreadEventData.setComposeTime((OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString())));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedInThreadEventData.setType(reader.getString());
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedInThreadEventData.setVersion((Long)reader.getNullable(JsonReader::getLong));
                    continue;
                }
                if ("messageBody".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedInThreadEventData.messageBody = reader.getString();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedAcsChatMessageReceivedInThreadEventData.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsChatMessageReceivedInThreadEventData;
        });
    }
}

