/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AvsClusterEventData;
import java.io.IOException;
import java.util.List;

public final class AvsClusterFailedEventData
extends AvsClusterEventData {
    private String failureMessage;

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public AvsClusterFailedEventData setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
        return this;
    }

    @Override
    public AvsClusterFailedEventData setOperationId(String operationId) {
        super.setOperationId(operationId);
        return this;
    }

    @Override
    public AvsClusterFailedEventData setAddedHostNames(List<String> addedHostNames) {
        super.setAddedHostNames(addedHostNames);
        return this;
    }

    @Override
    public AvsClusterFailedEventData setRemovedHostNames(List<String> removedHostNames) {
        super.setRemovedHostNames(removedHostNames);
        return this;
    }

    @Override
    public AvsClusterFailedEventData setInMaintenanceHostNames(List<String> inMaintenanceHostNames) {
        super.setInMaintenanceHostNames(inMaintenanceHostNames);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operationId", this.getOperationId());
        jsonWriter.writeArrayField("addedHostNames", this.getAddedHostNames(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("removedHostNames", this.getRemovedHostNames(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("inMaintenanceHostNames", this.getInMaintenanceHostNames(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("failureMessage", this.failureMessage);
        return jsonWriter.writeEndObject();
    }

    public static AvsClusterFailedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AvsClusterFailedEventData)jsonReader.readObject(reader -> {
            AvsClusterFailedEventData deserializedAvsClusterFailedEventData = new AvsClusterFailedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operationId".equals(fieldName)) {
                    deserializedAvsClusterFailedEventData.setOperationId(reader.getString());
                    continue;
                }
                if ("addedHostNames".equals(fieldName)) {
                    List addedHostNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedAvsClusterFailedEventData.setAddedHostNames(addedHostNames);
                    continue;
                }
                if ("removedHostNames".equals(fieldName)) {
                    List removedHostNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedAvsClusterFailedEventData.setRemovedHostNames(removedHostNames);
                    continue;
                }
                if ("inMaintenanceHostNames".equals(fieldName)) {
                    List inMaintenanceHostNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedAvsClusterFailedEventData.setInMaintenanceHostNames(inMaintenanceHostNames);
                    continue;
                }
                if ("failureMessage".equals(fieldName)) {
                    deserializedAvsClusterFailedEventData.failureMessage = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAvsClusterFailedEventData;
        });
    }
}

