/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.DataBoxStageName;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class DataBoxCopyCompletedEventData
implements JsonSerializable<DataBoxCopyCompletedEventData> {
    private String serialNumber;
    private DataBoxStageName stageName;
    private OffsetDateTime stageTime;

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public DataBoxCopyCompletedEventData setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    public DataBoxStageName getStageName() {
        return this.stageName;
    }

    public DataBoxCopyCompletedEventData setStageName(DataBoxStageName stageName) {
        this.stageName = stageName;
        return this;
    }

    public OffsetDateTime getStageTime() {
        return this.stageTime;
    }

    public DataBoxCopyCompletedEventData setStageTime(OffsetDateTime stageTime) {
        this.stageTime = stageTime;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serialNumber", this.serialNumber);
        jsonWriter.writeStringField("stageName", this.stageName == null ? null : this.stageName.toString());
        jsonWriter.writeStringField("stageTime", this.stageTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.stageTime));
        return jsonWriter.writeEndObject();
    }

    public static DataBoxCopyCompletedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (DataBoxCopyCompletedEventData)jsonReader.readObject(reader -> {
            DataBoxCopyCompletedEventData deserializedDataBoxCopyCompletedEventData = new DataBoxCopyCompletedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serialNumber".equals(fieldName)) {
                    deserializedDataBoxCopyCompletedEventData.serialNumber = reader.getString();
                    continue;
                }
                if ("stageName".equals(fieldName)) {
                    deserializedDataBoxCopyCompletedEventData.stageName = DataBoxStageName.fromString(reader.getString());
                    continue;
                }
                if ("stageTime".equals(fieldName)) {
                    deserializedDataBoxCopyCompletedEventData.stageTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataBoxCopyCompletedEventData;
        });
    }
}

