/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.MediaJobError;
import com.azure.messaging.eventgrid.systemevents.MediaJobOutput;
import com.azure.messaging.eventgrid.systemevents.MediaJobState;
import java.io.IOException;

public final class MediaJobOutputAsset
extends MediaJobOutput {
    private String assetName;

    public String getAssetName() {
        return this.assetName;
    }

    public MediaJobOutputAsset setAssetName(String assetName) {
        this.assetName = assetName;
        return this;
    }

    @Override
    public MediaJobOutputAsset setError(MediaJobError error) {
        super.setError(error);
        return this;
    }

    @Override
    public MediaJobOutputAsset setLabel(String label) {
        super.setLabel(label);
        return this;
    }

    @Override
    public MediaJobOutputAsset setProgress(long progress) {
        super.setProgress(progress);
        return this;
    }

    @Override
    public MediaJobOutputAsset setState(MediaJobState state) {
        super.setState(state);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Media.JobOutputAsset");
        jsonWriter.writeLongField("progress", this.getProgress());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeJsonField("error", (JsonSerializable)this.getError());
        jsonWriter.writeStringField("label", this.getLabel());
        jsonWriter.writeStringField("assetName", this.assetName);
        return jsonWriter.writeEndObject();
    }

    public static MediaJobOutputAsset fromJson(JsonReader jsonReader) throws IOException {
        return (MediaJobOutputAsset)jsonReader.readObject(reader -> {
            MediaJobOutputAsset deserializedMediaJobOutputAsset = new MediaJobOutputAsset();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if ("#Microsoft.Media.JobOutputAsset".equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Media.JobOutputAsset'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("progress".equals(fieldName)) {
                    deserializedMediaJobOutputAsset.setProgress(reader.getLong());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMediaJobOutputAsset.setState(MediaJobState.fromString(reader.getString()));
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedMediaJobOutputAsset.setError(MediaJobError.fromJson(reader));
                    continue;
                }
                if ("label".equals(fieldName)) {
                    deserializedMediaJobOutputAsset.setLabel(reader.getString());
                    continue;
                }
                if ("assetName".equals(fieldName)) {
                    deserializedMediaJobOutputAsset.assetName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMediaJobOutputAsset;
        });
    }
}

