/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid;

import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class EventGridEvent
implements JsonSerializable<EventGridEvent> {
    private final com.azure.messaging.eventgrid.implementation.models.EventGridEvent event;
    private static final ClientLogger LOGGER = new ClientLogger(EventGridEvent.class);
    private BinaryData binaryData;

    public EventGridEvent(String subject, String eventType, BinaryData data, String dataVersion) {
        Objects.requireNonNull(subject, "'subject' cannot be null.");
        Objects.requireNonNull(eventType, "'eventType' cannot be null.");
        Objects.requireNonNull(data, "'data' cannot be null");
        Objects.requireNonNull(dataVersion, "'dataVersion' cannot be null");
        this.event = new com.azure.messaging.eventgrid.implementation.models.EventGridEvent().setEventTime(OffsetDateTime.now()).setId(CoreUtils.randomUuid().toString()).setSubject(subject).setEventType(eventType).setDataVersion(dataVersion);
        this.binaryData = data;
        this.event.setData(data.toObject(Object.class));
    }

    private EventGridEvent(com.azure.messaging.eventgrid.implementation.models.EventGridEvent event, BinaryData data) {
        this.event = event;
        this.binaryData = data;
    }

    public static List<EventGridEvent> fromString(String eventGridJsonString) {
        ArrayList<EventGridEvent> arrayList;
        block14: {
            JsonReader jsonReader = JsonProviders.createReader((String)eventGridJsonString);
            try {
                JsonToken token = jsonReader.nextToken();
                List<com.azure.messaging.eventgrid.implementation.models.EventGridEvent> internalEvents = token == JsonToken.START_ARRAY ? jsonReader.readArray(com.azure.messaging.eventgrid.implementation.models.EventGridEvent::fromJson) : Collections.singletonList(com.azure.messaging.eventgrid.implementation.models.EventGridEvent.fromJson(jsonReader));
                ArrayList<EventGridEvent> events = new ArrayList<EventGridEvent>();
                for (int i = 0; i < internalEvents.size(); ++i) {
                    com.azure.messaging.eventgrid.implementation.models.EventGridEvent internalEvent = internalEvents.get(i);
                    if (internalEvent.getSubject() == null || internalEvent.getEventType() == null || internalEvent.getData() == null || internalEvent.getDataVersion() == null) {
                        ArrayList<String> nullAttributes = new ArrayList<String>();
                        if (internalEvent.getSubject() == null) {
                            nullAttributes.add("'subject'");
                        }
                        if (internalEvent.getEventType() == null) {
                            nullAttributes.add("'eventType'");
                        }
                        if (internalEvent.getData() == null) {
                            nullAttributes.add("'data'");
                        }
                        if (internalEvent.getDataVersion() == null) {
                            nullAttributes.add("'dataVersion'");
                        }
                        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'subject', 'eventType', 'data' and 'dataVersion' are mandatory attributes for an EventGridEvent. This Json string doesn't have " + CoreUtils.stringJoin((String)",", nullAttributes) + " for the object at index " + i + ". Please make sure the input Json string has the required attributes"));
                    }
                    events.add(new EventGridEvent(internalEvent));
                }
                arrayList = events;
                if (jsonReader == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("The input parameter isn't a JSON string.", ex.getCause()));
                }
            }
            jsonReader.close();
        }
        return arrayList;
    }

    public String getId() {
        return this.event.getId();
    }

    public EventGridEvent setId(String id) {
        Objects.requireNonNull(id, "'id' cannot be null.");
        if (id.isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'id' cannot be empty."));
        }
        this.event.setId(id);
        return this;
    }

    public String getTopic() {
        return this.event.getTopic();
    }

    public EventGridEvent setTopic(String topic) {
        this.event.setTopic(topic);
        return this;
    }

    public String getSubject() {
        return this.event.getSubject();
    }

    public BinaryData getData() {
        Object data;
        if (this.binaryData == null && (data = this.event.getData()) != null) {
            this.binaryData = BinaryData.fromObject((Object)data);
        }
        return this.binaryData;
    }

    public String getEventType() {
        return this.event.getEventType();
    }

    public OffsetDateTime getEventTime() {
        return this.event.getEventTime();
    }

    public EventGridEvent setEventTime(OffsetDateTime time) {
        this.event.setEventTime(time);
        return this;
    }

    public String getDataVersion() {
        return this.event.getDataVersion();
    }

    EventGridEvent(com.azure.messaging.eventgrid.implementation.models.EventGridEvent impl) {
        this.event = impl;
    }

    com.azure.messaging.eventgrid.implementation.models.EventGridEvent toImpl() {
        return this.event;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("event", (JsonSerializable)this.event);
        jsonWriter.writeBinaryField("binaryData", this.binaryData.toBytes());
        return jsonWriter.writeEndObject();
    }

    public static EventGridEvent fromJson(JsonReader jsonReader) throws IOException {
        return (EventGridEvent)jsonReader.readObject(reader -> {
            com.azure.messaging.eventgrid.implementation.models.EventGridEvent internalEvent = null;
            BinaryData data = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("event".equals(fieldName)) {
                    internalEvent = com.azure.messaging.eventgrid.implementation.models.EventGridEvent.fromJson(reader);
                    continue;
                }
                if ("binaryData".equals(fieldName)) {
                    data = BinaryData.fromBytes((byte[])reader.getBinary());
                    continue;
                }
                reader.skipChildren();
            }
            return new EventGridEvent(internalEvent, data);
        });
    }
}

