/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsSmsDeliveryAttemptProperties;
import com.azure.messaging.eventgrid.systemevents.AcsSmsEventBaseProperties;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class AcsSmsDeliveryReportReceivedEventData
extends AcsSmsEventBaseProperties {
    private String deliveryStatus;
    private String deliveryStatusDetails;
    private List<AcsSmsDeliveryAttemptProperties> deliveryAttempts;
    private OffsetDateTime receivedTimestamp;
    private String tag;

    public String getDeliveryStatus() {
        return this.deliveryStatus;
    }

    public AcsSmsDeliveryReportReceivedEventData setDeliveryStatus(String deliveryStatus) {
        this.deliveryStatus = deliveryStatus;
        return this;
    }

    public String getDeliveryStatusDetails() {
        return this.deliveryStatusDetails;
    }

    public AcsSmsDeliveryReportReceivedEventData setDeliveryStatusDetails(String deliveryStatusDetails) {
        this.deliveryStatusDetails = deliveryStatusDetails;
        return this;
    }

    public List<AcsSmsDeliveryAttemptProperties> getDeliveryAttempts() {
        return this.deliveryAttempts;
    }

    public AcsSmsDeliveryReportReceivedEventData setDeliveryAttempts(List<AcsSmsDeliveryAttemptProperties> deliveryAttempts) {
        this.deliveryAttempts = deliveryAttempts;
        return this;
    }

    public OffsetDateTime getReceivedTimestamp() {
        return this.receivedTimestamp;
    }

    public AcsSmsDeliveryReportReceivedEventData setReceivedTimestamp(OffsetDateTime receivedTimestamp) {
        this.receivedTimestamp = receivedTimestamp;
        return this;
    }

    public String getTag() {
        return this.tag;
    }

    public AcsSmsDeliveryReportReceivedEventData setTag(String tag) {
        this.tag = tag;
        return this;
    }

    @Override
    public AcsSmsDeliveryReportReceivedEventData setMessageId(String messageId) {
        super.setMessageId(messageId);
        return this;
    }

    @Override
    public AcsSmsDeliveryReportReceivedEventData setFrom(String from) {
        super.setFrom(from);
        return this;
    }

    @Override
    public AcsSmsDeliveryReportReceivedEventData setTo(String to) {
        super.setTo(to);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("messageId", this.getMessageId());
        jsonWriter.writeStringField("from", this.getFrom());
        jsonWriter.writeStringField("to", this.getTo());
        jsonWriter.writeStringField("deliveryStatus", this.deliveryStatus);
        jsonWriter.writeStringField("deliveryStatusDetails", this.deliveryStatusDetails);
        jsonWriter.writeArrayField("deliveryAttempts", this.deliveryAttempts, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("receivedTimestamp", this.receivedTimestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.receivedTimestamp));
        jsonWriter.writeStringField("tag", this.tag);
        return jsonWriter.writeEndObject();
    }

    public static AcsSmsDeliveryReportReceivedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsSmsDeliveryReportReceivedEventData)jsonReader.readObject(reader -> {
            AcsSmsDeliveryReportReceivedEventData deserializedAcsSmsDeliveryReportReceivedEventData = new AcsSmsDeliveryReportReceivedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("messageId".equals(fieldName)) {
                    deserializedAcsSmsDeliveryReportReceivedEventData.setMessageId(reader.getString());
                    continue;
                }
                if ("from".equals(fieldName)) {
                    deserializedAcsSmsDeliveryReportReceivedEventData.setFrom(reader.getString());
                    continue;
                }
                if ("to".equals(fieldName)) {
                    deserializedAcsSmsDeliveryReportReceivedEventData.setTo(reader.getString());
                    continue;
                }
                if ("deliveryStatus".equals(fieldName)) {
                    deserializedAcsSmsDeliveryReportReceivedEventData.deliveryStatus = reader.getString();
                    continue;
                }
                if ("deliveryStatusDetails".equals(fieldName)) {
                    deserializedAcsSmsDeliveryReportReceivedEventData.deliveryStatusDetails = reader.getString();
                    continue;
                }
                if ("deliveryAttempts".equals(fieldName)) {
                    List deliveryAttempts;
                    deserializedAcsSmsDeliveryReportReceivedEventData.deliveryAttempts = deliveryAttempts = reader.readArray(reader1 -> AcsSmsDeliveryAttemptProperties.fromJson(reader1));
                    continue;
                }
                if ("receivedTimestamp".equals(fieldName)) {
                    deserializedAcsSmsDeliveryReportReceivedEventData.receivedTimestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("tag".equals(fieldName)) {
                    deserializedAcsSmsDeliveryReportReceivedEventData.tag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsSmsDeliveryReportReceivedEventData;
        });
    }
}

