/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class EventHubCaptureFileCreatedEventData
implements JsonSerializable<EventHubCaptureFileCreatedEventData> {
    private String fileurl;
    private String fileType;
    private String partitionId;
    private Integer sizeInBytes;
    private Integer eventCount;
    private Integer firstSequenceNumber;
    private Integer lastSequenceNumber;
    private OffsetDateTime firstEnqueueTime;
    private OffsetDateTime lastEnqueueTime;

    public String getFileurl() {
        return this.fileurl;
    }

    public EventHubCaptureFileCreatedEventData setFileurl(String fileurl) {
        this.fileurl = fileurl;
        return this;
    }

    public String getFileType() {
        return this.fileType;
    }

    public EventHubCaptureFileCreatedEventData setFileType(String fileType) {
        this.fileType = fileType;
        return this;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public EventHubCaptureFileCreatedEventData setPartitionId(String partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public Integer getSizeInBytes() {
        return this.sizeInBytes;
    }

    public EventHubCaptureFileCreatedEventData setSizeInBytes(Integer sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
        return this;
    }

    public Integer getEventCount() {
        return this.eventCount;
    }

    public EventHubCaptureFileCreatedEventData setEventCount(Integer eventCount) {
        this.eventCount = eventCount;
        return this;
    }

    public Integer getFirstSequenceNumber() {
        return this.firstSequenceNumber;
    }

    public EventHubCaptureFileCreatedEventData setFirstSequenceNumber(Integer firstSequenceNumber) {
        this.firstSequenceNumber = firstSequenceNumber;
        return this;
    }

    public Integer getLastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    public EventHubCaptureFileCreatedEventData setLastSequenceNumber(Integer lastSequenceNumber) {
        this.lastSequenceNumber = lastSequenceNumber;
        return this;
    }

    public OffsetDateTime getFirstEnqueueTime() {
        return this.firstEnqueueTime;
    }

    public EventHubCaptureFileCreatedEventData setFirstEnqueueTime(OffsetDateTime firstEnqueueTime) {
        this.firstEnqueueTime = firstEnqueueTime;
        return this;
    }

    public OffsetDateTime getLastEnqueueTime() {
        return this.lastEnqueueTime;
    }

    public EventHubCaptureFileCreatedEventData setLastEnqueueTime(OffsetDateTime lastEnqueueTime) {
        this.lastEnqueueTime = lastEnqueueTime;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("fileUrl", this.fileurl);
        jsonWriter.writeStringField("fileType", this.fileType);
        jsonWriter.writeStringField("partitionId", this.partitionId);
        jsonWriter.writeNumberField("sizeInBytes", (Number)this.sizeInBytes);
        jsonWriter.writeNumberField("eventCount", (Number)this.eventCount);
        jsonWriter.writeNumberField("firstSequenceNumber", (Number)this.firstSequenceNumber);
        jsonWriter.writeNumberField("lastSequenceNumber", (Number)this.lastSequenceNumber);
        jsonWriter.writeStringField("firstEnqueueTime", this.firstEnqueueTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.firstEnqueueTime));
        jsonWriter.writeStringField("lastEnqueueTime", this.lastEnqueueTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastEnqueueTime));
        return jsonWriter.writeEndObject();
    }

    public static EventHubCaptureFileCreatedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (EventHubCaptureFileCreatedEventData)jsonReader.readObject(reader -> {
            EventHubCaptureFileCreatedEventData deserializedEventHubCaptureFileCreatedEventData = new EventHubCaptureFileCreatedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("fileUrl".equals(fieldName)) {
                    deserializedEventHubCaptureFileCreatedEventData.fileurl = reader.getString();
                    continue;
                }
                if ("fileType".equals(fieldName)) {
                    deserializedEventHubCaptureFileCreatedEventData.fileType = reader.getString();
                    continue;
                }
                if ("partitionId".equals(fieldName)) {
                    deserializedEventHubCaptureFileCreatedEventData.partitionId = reader.getString();
                    continue;
                }
                if ("sizeInBytes".equals(fieldName)) {
                    deserializedEventHubCaptureFileCreatedEventData.sizeInBytes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("eventCount".equals(fieldName)) {
                    deserializedEventHubCaptureFileCreatedEventData.eventCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("firstSequenceNumber".equals(fieldName)) {
                    deserializedEventHubCaptureFileCreatedEventData.firstSequenceNumber = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("lastSequenceNumber".equals(fieldName)) {
                    deserializedEventHubCaptureFileCreatedEventData.lastSequenceNumber = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("firstEnqueueTime".equals(fieldName)) {
                    deserializedEventHubCaptureFileCreatedEventData.firstEnqueueTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("lastEnqueueTime".equals(fieldName)) {
                    deserializedEventHubCaptureFileCreatedEventData.lastEnqueueTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEventHubCaptureFileCreatedEventData;
        });
    }
}

