/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsChatMessageEventBaseProperties;
import com.azure.messaging.eventgrid.systemevents.CommunicationIdentifierModel;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class AcsChatMessageDeletedEventData
extends AcsChatMessageEventBaseProperties {
    private OffsetDateTime deleteTime;

    public OffsetDateTime getDeleteTime() {
        return this.deleteTime;
    }

    public AcsChatMessageDeletedEventData setDeleteTime(OffsetDateTime deleteTime) {
        this.deleteTime = deleteTime;
        return this;
    }

    @Override
    public AcsChatMessageDeletedEventData setMessageId(String messageId) {
        super.setMessageId(messageId);
        return this;
    }

    @Override
    public AcsChatMessageDeletedEventData setSenderCommunicationIdentifier(CommunicationIdentifierModel senderCommunicationIdentifier) {
        super.setSenderCommunicationIdentifier(senderCommunicationIdentifier);
        return this;
    }

    @Override
    public AcsChatMessageDeletedEventData setSenderDisplayName(String senderDisplayName) {
        super.setSenderDisplayName(senderDisplayName);
        return this;
    }

    @Override
    public AcsChatMessageDeletedEventData setComposeTime(OffsetDateTime composeTime) {
        super.setComposeTime(composeTime);
        return this;
    }

    @Override
    public AcsChatMessageDeletedEventData setType(String type) {
        super.setType(type);
        return this;
    }

    @Override
    public AcsChatMessageDeletedEventData setVersion(Long version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AcsChatMessageDeletedEventData setRecipientCommunicationIdentifier(CommunicationIdentifierModel recipientCommunicationIdentifier) {
        super.setRecipientCommunicationIdentifier(recipientCommunicationIdentifier);
        return this;
    }

    @Override
    public AcsChatMessageDeletedEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    @Override
    public AcsChatMessageDeletedEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("recipientCommunicationIdentifier", (JsonSerializable)this.getRecipientCommunicationIdentifier());
        jsonWriter.writeStringField("transactionId", this.getTransactionId());
        jsonWriter.writeStringField("threadId", this.getThreadId());
        jsonWriter.writeStringField("messageId", this.getMessageId());
        jsonWriter.writeJsonField("senderCommunicationIdentifier", (JsonSerializable)this.getSenderCommunicationIdentifier());
        jsonWriter.writeStringField("senderDisplayName", this.getSenderDisplayName());
        jsonWriter.writeStringField("composeTime", this.getComposeTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getComposeTime()));
        jsonWriter.writeStringField("type", this.getType());
        jsonWriter.writeNumberField("version", (Number)this.getVersion());
        jsonWriter.writeStringField("deleteTime", this.deleteTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.deleteTime));
        return jsonWriter.writeEndObject();
    }

    public static AcsChatMessageDeletedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsChatMessageDeletedEventData)jsonReader.readObject(reader -> {
            AcsChatMessageDeletedEventData deserializedAcsChatMessageDeletedEventData = new AcsChatMessageDeletedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("recipientCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatMessageDeletedEventData.setRecipientCommunicationIdentifier(CommunicationIdentifierModel.fromJson(reader));
                    continue;
                }
                if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatMessageDeletedEventData.setTransactionId(reader.getString());
                    continue;
                }
                if ("threadId".equals(fieldName)) {
                    deserializedAcsChatMessageDeletedEventData.setThreadId(reader.getString());
                    continue;
                }
                if ("messageId".equals(fieldName)) {
                    deserializedAcsChatMessageDeletedEventData.setMessageId(reader.getString());
                    continue;
                }
                if ("senderCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatMessageDeletedEventData.setSenderCommunicationIdentifier(CommunicationIdentifierModel.fromJson(reader));
                    continue;
                }
                if ("senderDisplayName".equals(fieldName)) {
                    deserializedAcsChatMessageDeletedEventData.setSenderDisplayName(reader.getString());
                    continue;
                }
                if ("composeTime".equals(fieldName)) {
                    deserializedAcsChatMessageDeletedEventData.setComposeTime((OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString())));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAcsChatMessageDeletedEventData.setType(reader.getString());
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedAcsChatMessageDeletedEventData.setVersion((Long)reader.getNullable(JsonReader::getLong));
                    continue;
                }
                if ("deleteTime".equals(fieldName)) {
                    deserializedAcsChatMessageDeletedEventData.deleteTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsChatMessageDeletedEventData;
        });
    }
}

