/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsChatEventBaseProperties;
import com.azure.messaging.eventgrid.systemevents.CommunicationIdentifierModel;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public class AcsChatMessageEventBaseProperties
extends AcsChatEventBaseProperties {
    private String messageId;
    private CommunicationIdentifierModel senderCommunicationIdentifier;
    private String senderDisplayName;
    private OffsetDateTime composeTime;
    private String type;
    private Long version;

    public String getMessageId() {
        return this.messageId;
    }

    public AcsChatMessageEventBaseProperties setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    public CommunicationIdentifierModel getSenderCommunicationIdentifier() {
        return this.senderCommunicationIdentifier;
    }

    public AcsChatMessageEventBaseProperties setSenderCommunicationIdentifier(CommunicationIdentifierModel senderCommunicationIdentifier) {
        this.senderCommunicationIdentifier = senderCommunicationIdentifier;
        return this;
    }

    public String getSenderDisplayName() {
        return this.senderDisplayName;
    }

    public AcsChatMessageEventBaseProperties setSenderDisplayName(String senderDisplayName) {
        this.senderDisplayName = senderDisplayName;
        return this;
    }

    public OffsetDateTime getComposeTime() {
        return this.composeTime;
    }

    public AcsChatMessageEventBaseProperties setComposeTime(OffsetDateTime composeTime) {
        this.composeTime = composeTime;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public AcsChatMessageEventBaseProperties setType(String type) {
        this.type = type;
        return this;
    }

    public Long getVersion() {
        return this.version;
    }

    public AcsChatMessageEventBaseProperties setVersion(Long version) {
        this.version = version;
        return this;
    }

    @Override
    public AcsChatMessageEventBaseProperties setRecipientCommunicationIdentifier(CommunicationIdentifierModel recipientCommunicationIdentifier) {
        super.setRecipientCommunicationIdentifier(recipientCommunicationIdentifier);
        return this;
    }

    @Override
    public AcsChatMessageEventBaseProperties setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    @Override
    public AcsChatMessageEventBaseProperties setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("recipientCommunicationIdentifier", (JsonSerializable)this.getRecipientCommunicationIdentifier());
        jsonWriter.writeStringField("transactionId", this.getTransactionId());
        jsonWriter.writeStringField("threadId", this.getThreadId());
        jsonWriter.writeStringField("messageId", this.messageId);
        jsonWriter.writeJsonField("senderCommunicationIdentifier", (JsonSerializable)this.senderCommunicationIdentifier);
        jsonWriter.writeStringField("senderDisplayName", this.senderDisplayName);
        jsonWriter.writeStringField("composeTime", this.composeTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.composeTime));
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeNumberField("version", (Number)this.version);
        return jsonWriter.writeEndObject();
    }

    public static AcsChatMessageEventBaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AcsChatMessageEventBaseProperties)jsonReader.readObject(reader -> {
            AcsChatMessageEventBaseProperties deserializedAcsChatMessageEventBaseProperties = new AcsChatMessageEventBaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("recipientCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatMessageEventBaseProperties.setRecipientCommunicationIdentifier(CommunicationIdentifierModel.fromJson(reader));
                    continue;
                }
                if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatMessageEventBaseProperties.setTransactionId(reader.getString());
                    continue;
                }
                if ("threadId".equals(fieldName)) {
                    deserializedAcsChatMessageEventBaseProperties.setThreadId(reader.getString());
                    continue;
                }
                if ("messageId".equals(fieldName)) {
                    deserializedAcsChatMessageEventBaseProperties.messageId = reader.getString();
                    continue;
                }
                if ("senderCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatMessageEventBaseProperties.senderCommunicationIdentifier = CommunicationIdentifierModel.fromJson(reader);
                    continue;
                }
                if ("senderDisplayName".equals(fieldName)) {
                    deserializedAcsChatMessageEventBaseProperties.senderDisplayName = reader.getString();
                    continue;
                }
                if ("composeTime".equals(fieldName)) {
                    deserializedAcsChatMessageEventBaseProperties.composeTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAcsChatMessageEventBaseProperties.type = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedAcsChatMessageEventBaseProperties.version = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsChatMessageEventBaseProperties;
        });
    }
}

