/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsUserEngagement;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class AcsEmailEngagementTrackingReportReceivedEventData
implements JsonSerializable<AcsEmailEngagementTrackingReportReceivedEventData> {
    private String sender;
    private String recipient;
    private String messageId;
    private OffsetDateTime userActionTimestamp;
    private String engagementContext;
    private String userAgent;
    private AcsUserEngagement engagement;

    public String getSender() {
        return this.sender;
    }

    public AcsEmailEngagementTrackingReportReceivedEventData setSender(String sender) {
        this.sender = sender;
        return this;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public AcsEmailEngagementTrackingReportReceivedEventData setRecipient(String recipient) {
        this.recipient = recipient;
        return this;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public AcsEmailEngagementTrackingReportReceivedEventData setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    public OffsetDateTime getUserActionTimestamp() {
        return this.userActionTimestamp;
    }

    public AcsEmailEngagementTrackingReportReceivedEventData setUserActionTimestamp(OffsetDateTime userActionTimestamp) {
        this.userActionTimestamp = userActionTimestamp;
        return this;
    }

    public String getEngagementContext() {
        return this.engagementContext;
    }

    public AcsEmailEngagementTrackingReportReceivedEventData setEngagementContext(String engagementContext) {
        this.engagementContext = engagementContext;
        return this;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public AcsEmailEngagementTrackingReportReceivedEventData setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public AcsUserEngagement getEngagement() {
        return this.engagement;
    }

    public AcsEmailEngagementTrackingReportReceivedEventData setEngagement(AcsUserEngagement engagement) {
        this.engagement = engagement;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sender", this.sender);
        jsonWriter.writeStringField("recipient", this.recipient);
        jsonWriter.writeStringField("messageId", this.messageId);
        jsonWriter.writeStringField("userActionTimestamp", this.userActionTimestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.userActionTimestamp));
        jsonWriter.writeStringField("engagementContext", this.engagementContext);
        jsonWriter.writeStringField("userAgent", this.userAgent);
        jsonWriter.writeStringField("engagementType", this.engagement == null ? null : this.engagement.toString());
        return jsonWriter.writeEndObject();
    }

    public static AcsEmailEngagementTrackingReportReceivedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsEmailEngagementTrackingReportReceivedEventData)jsonReader.readObject(reader -> {
            AcsEmailEngagementTrackingReportReceivedEventData deserializedAcsEmailEngagementTrackingReportReceivedEventData = new AcsEmailEngagementTrackingReportReceivedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sender".equals(fieldName)) {
                    deserializedAcsEmailEngagementTrackingReportReceivedEventData.sender = reader.getString();
                    continue;
                }
                if ("recipient".equals(fieldName)) {
                    deserializedAcsEmailEngagementTrackingReportReceivedEventData.recipient = reader.getString();
                    continue;
                }
                if ("messageId".equals(fieldName)) {
                    deserializedAcsEmailEngagementTrackingReportReceivedEventData.messageId = reader.getString();
                    continue;
                }
                if ("userActionTimestamp".equals(fieldName)) {
                    deserializedAcsEmailEngagementTrackingReportReceivedEventData.userActionTimestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("engagementContext".equals(fieldName)) {
                    deserializedAcsEmailEngagementTrackingReportReceivedEventData.engagementContext = reader.getString();
                    continue;
                }
                if ("userAgent".equals(fieldName)) {
                    deserializedAcsEmailEngagementTrackingReportReceivedEventData.userAgent = reader.getString();
                    continue;
                }
                if ("engagementType".equals(fieldName)) {
                    deserializedAcsEmailEngagementTrackingReportReceivedEventData.engagement = AcsUserEngagement.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsEmailEngagementTrackingReportReceivedEventData;
        });
    }
}

