/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.MediaJobOutput;
import com.azure.messaging.eventgrid.systemevents.MediaJobOutputStateChangeEventData;
import com.azure.messaging.eventgrid.systemevents.MediaJobState;
import java.io.IOException;
import java.util.Map;

public final class MediaJobOutputFinishedEventData
extends MediaJobOutputStateChangeEventData {
    @Override
    public MediaJobOutputFinishedEventData setOutput(MediaJobOutput output) {
        super.setOutput(output);
        return this;
    }

    @Override
    public MediaJobOutputFinishedEventData setJobCorrelationData(Map<String, String> jobCorrelationData) {
        super.setJobCorrelationData(jobCorrelationData);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("output", (JsonSerializable)this.getOutput());
        jsonWriter.writeMapField("jobCorrelationData", this.getJobCorrelationData(), (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static MediaJobOutputFinishedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (MediaJobOutputFinishedEventData)jsonReader.readObject(reader -> {
            MediaJobOutputFinishedEventData deserializedMediaJobOutputFinishedEventData = new MediaJobOutputFinishedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("previousState".equals(fieldName)) {
                    deserializedMediaJobOutputFinishedEventData.setPreviousState(MediaJobState.fromString(reader.getString()));
                    continue;
                }
                if ("output".equals(fieldName)) {
                    deserializedMediaJobOutputFinishedEventData.setOutput(MediaJobOutput.fromJson(reader));
                    continue;
                }
                if ("jobCorrelationData".equals(fieldName)) {
                    Map jobCorrelationData = reader.readMap(reader1 -> reader1.getString());
                    deserializedMediaJobOutputFinishedEventData.setJobCorrelationData(jobCorrelationData);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMediaJobOutputFinishedEventData;
        });
    }
}

