/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class SignalRServiceClientConnectionDisconnectedEventData
implements JsonSerializable<SignalRServiceClientConnectionDisconnectedEventData> {
    private OffsetDateTime timestamp;
    private String hubName;
    private String connectionId;
    private String userId;
    private String errorMessage;

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public SignalRServiceClientConnectionDisconnectedEventData setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String getHubName() {
        return this.hubName;
    }

    public SignalRServiceClientConnectionDisconnectedEventData setHubName(String hubName) {
        this.hubName = hubName;
        return this;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public SignalRServiceClientConnectionDisconnectedEventData setConnectionId(String connectionId) {
        this.connectionId = connectionId;
        return this;
    }

    public String getUserId() {
        return this.userId;
    }

    public SignalRServiceClientConnectionDisconnectedEventData setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public SignalRServiceClientConnectionDisconnectedEventData setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timestamp", this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeStringField("hubName", this.hubName);
        jsonWriter.writeStringField("connectionId", this.connectionId);
        jsonWriter.writeStringField("userId", this.userId);
        jsonWriter.writeStringField("errorMessage", this.errorMessage);
        return jsonWriter.writeEndObject();
    }

    public static SignalRServiceClientConnectionDisconnectedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (SignalRServiceClientConnectionDisconnectedEventData)jsonReader.readObject(reader -> {
            SignalRServiceClientConnectionDisconnectedEventData deserializedSignalRServiceClientConnectionDisconnectedEventData = new SignalRServiceClientConnectionDisconnectedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timestamp".equals(fieldName)) {
                    deserializedSignalRServiceClientConnectionDisconnectedEventData.timestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("hubName".equals(fieldName)) {
                    deserializedSignalRServiceClientConnectionDisconnectedEventData.hubName = reader.getString();
                    continue;
                }
                if ("connectionId".equals(fieldName)) {
                    deserializedSignalRServiceClientConnectionDisconnectedEventData.connectionId = reader.getString();
                    continue;
                }
                if ("userId".equals(fieldName)) {
                    deserializedSignalRServiceClientConnectionDisconnectedEventData.userId = reader.getString();
                    continue;
                }
                if ("errorMessage".equals(fieldName)) {
                    deserializedSignalRServiceClientConnectionDisconnectedEventData.errorMessage = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSignalRServiceClientConnectionDisconnectedEventData;
        });
    }
}

