/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class StorageBlobInventoryPolicyCompletedEventData
implements JsonSerializable<StorageBlobInventoryPolicyCompletedEventData> {
    private OffsetDateTime scheduleDateTime;
    private String accountName;
    private String ruleName;
    private String policyRunStatus;
    private String policyRunStatusMessage;
    private String policyRunId;
    private String manifestBlobUrl;

    public OffsetDateTime getScheduleDateTime() {
        return this.scheduleDateTime;
    }

    public StorageBlobInventoryPolicyCompletedEventData setScheduleDateTime(OffsetDateTime scheduleDateTime) {
        this.scheduleDateTime = scheduleDateTime;
        return this;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public StorageBlobInventoryPolicyCompletedEventData setAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public StorageBlobInventoryPolicyCompletedEventData setRuleName(String ruleName) {
        this.ruleName = ruleName;
        return this;
    }

    public String getPolicyRunStatus() {
        return this.policyRunStatus;
    }

    public StorageBlobInventoryPolicyCompletedEventData setPolicyRunStatus(String policyRunStatus) {
        this.policyRunStatus = policyRunStatus;
        return this;
    }

    public String getPolicyRunStatusMessage() {
        return this.policyRunStatusMessage;
    }

    public StorageBlobInventoryPolicyCompletedEventData setPolicyRunStatusMessage(String policyRunStatusMessage) {
        this.policyRunStatusMessage = policyRunStatusMessage;
        return this;
    }

    public String getPolicyRunId() {
        return this.policyRunId;
    }

    public StorageBlobInventoryPolicyCompletedEventData setPolicyRunId(String policyRunId) {
        this.policyRunId = policyRunId;
        return this;
    }

    public String getManifestBlobUrl() {
        return this.manifestBlobUrl;
    }

    public StorageBlobInventoryPolicyCompletedEventData setManifestBlobUrl(String manifestBlobUrl) {
        this.manifestBlobUrl = manifestBlobUrl;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scheduleDateTime", this.scheduleDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.scheduleDateTime));
        jsonWriter.writeStringField("accountName", this.accountName);
        jsonWriter.writeStringField("ruleName", this.ruleName);
        jsonWriter.writeStringField("policyRunStatus", this.policyRunStatus);
        jsonWriter.writeStringField("policyRunStatusMessage", this.policyRunStatusMessage);
        jsonWriter.writeStringField("policyRunId", this.policyRunId);
        jsonWriter.writeStringField("manifestBlobUrl", this.manifestBlobUrl);
        return jsonWriter.writeEndObject();
    }

    public static StorageBlobInventoryPolicyCompletedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (StorageBlobInventoryPolicyCompletedEventData)jsonReader.readObject(reader -> {
            StorageBlobInventoryPolicyCompletedEventData deserializedStorageBlobInventoryPolicyCompletedEventData = new StorageBlobInventoryPolicyCompletedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scheduleDateTime".equals(fieldName)) {
                    deserializedStorageBlobInventoryPolicyCompletedEventData.scheduleDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("accountName".equals(fieldName)) {
                    deserializedStorageBlobInventoryPolicyCompletedEventData.accountName = reader.getString();
                    continue;
                }
                if ("ruleName".equals(fieldName)) {
                    deserializedStorageBlobInventoryPolicyCompletedEventData.ruleName = reader.getString();
                    continue;
                }
                if ("policyRunStatus".equals(fieldName)) {
                    deserializedStorageBlobInventoryPolicyCompletedEventData.policyRunStatus = reader.getString();
                    continue;
                }
                if ("policyRunStatusMessage".equals(fieldName)) {
                    deserializedStorageBlobInventoryPolicyCompletedEventData.policyRunStatusMessage = reader.getString();
                    continue;
                }
                if ("policyRunId".equals(fieldName)) {
                    deserializedStorageBlobInventoryPolicyCompletedEventData.policyRunId = reader.getString();
                    continue;
                }
                if ("manifestBlobUrl".equals(fieldName)) {
                    deserializedStorageBlobInventoryPolicyCompletedEventData.manifestBlobUrl = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageBlobInventoryPolicyCompletedEventData;
        });
    }
}

