/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsEmailDeliveryReportStatus;
import com.azure.messaging.eventgrid.systemevents.AcsEmailDeliveryReportStatusDetails;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class AcsEmailDeliveryReportReceivedEventData
implements JsonSerializable<AcsEmailDeliveryReportReceivedEventData> {
    private String sender;
    private String recipient;
    private String messageId;
    private AcsEmailDeliveryReportStatus status;
    private AcsEmailDeliveryReportStatusDetails deliveryStatusDetails;
    private OffsetDateTime deliveryAttemptTimestamp;

    public String getSender() {
        return this.sender;
    }

    public AcsEmailDeliveryReportReceivedEventData setSender(String sender) {
        this.sender = sender;
        return this;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public AcsEmailDeliveryReportReceivedEventData setRecipient(String recipient) {
        this.recipient = recipient;
        return this;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public AcsEmailDeliveryReportReceivedEventData setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    public AcsEmailDeliveryReportStatus getStatus() {
        return this.status;
    }

    public AcsEmailDeliveryReportReceivedEventData setStatus(AcsEmailDeliveryReportStatus status) {
        this.status = status;
        return this;
    }

    public AcsEmailDeliveryReportStatusDetails getDeliveryStatusDetails() {
        return this.deliveryStatusDetails;
    }

    public AcsEmailDeliveryReportReceivedEventData setDeliveryStatusDetails(AcsEmailDeliveryReportStatusDetails deliveryStatusDetails) {
        this.deliveryStatusDetails = deliveryStatusDetails;
        return this;
    }

    public OffsetDateTime getDeliveryAttemptTimestamp() {
        return this.deliveryAttemptTimestamp;
    }

    public AcsEmailDeliveryReportReceivedEventData setDeliveryAttemptTimestamp(OffsetDateTime deliveryAttemptTimestamp) {
        this.deliveryAttemptTimestamp = deliveryAttemptTimestamp;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sender", this.sender);
        jsonWriter.writeStringField("recipient", this.recipient);
        jsonWriter.writeStringField("messageId", this.messageId);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeJsonField("deliveryStatusDetails", (JsonSerializable)this.deliveryStatusDetails);
        jsonWriter.writeStringField("deliveryAttemptTimestamp", this.deliveryAttemptTimestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.deliveryAttemptTimestamp));
        return jsonWriter.writeEndObject();
    }

    public static AcsEmailDeliveryReportReceivedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsEmailDeliveryReportReceivedEventData)jsonReader.readObject(reader -> {
            AcsEmailDeliveryReportReceivedEventData deserializedAcsEmailDeliveryReportReceivedEventData = new AcsEmailDeliveryReportReceivedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sender".equals(fieldName)) {
                    deserializedAcsEmailDeliveryReportReceivedEventData.sender = reader.getString();
                    continue;
                }
                if ("recipient".equals(fieldName)) {
                    deserializedAcsEmailDeliveryReportReceivedEventData.recipient = reader.getString();
                    continue;
                }
                if ("messageId".equals(fieldName)) {
                    deserializedAcsEmailDeliveryReportReceivedEventData.messageId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedAcsEmailDeliveryReportReceivedEventData.status = AcsEmailDeliveryReportStatus.fromString(reader.getString());
                    continue;
                }
                if ("deliveryStatusDetails".equals(fieldName)) {
                    deserializedAcsEmailDeliveryReportReceivedEventData.deliveryStatusDetails = AcsEmailDeliveryReportStatusDetails.fromJson(reader);
                    continue;
                }
                if ("deliveryAttemptTimestamp".equals(fieldName)) {
                    deserializedAcsEmailDeliveryReportReceivedEventData.deliveryAttemptTimestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsEmailDeliveryReportReceivedEventData;
        });
    }
}

