/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.models.ResponseError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.implementation.models.AcsMessageChannelEventError;
import com.azure.messaging.eventgrid.systemevents.AcsMessageChannelKind;
import com.azure.messaging.eventgrid.systemevents.AcsMessageDeliveryStatus;
import com.azure.messaging.eventgrid.systemevents.AcsMessageEventData;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class AcsMessageDeliveryStatusUpdatedEventData
extends AcsMessageEventData {
    private String messageId;
    private AcsMessageDeliveryStatus status;
    private AcsMessageChannelKind channelKind;

    public String getMessageId() {
        return this.messageId;
    }

    public AcsMessageDeliveryStatusUpdatedEventData setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    public AcsMessageDeliveryStatus getStatus() {
        return this.status;
    }

    public AcsMessageDeliveryStatusUpdatedEventData setStatus(AcsMessageDeliveryStatus status) {
        this.status = status;
        return this;
    }

    public AcsMessageChannelKind getChannelKind() {
        return this.channelKind;
    }

    public AcsMessageDeliveryStatusUpdatedEventData setChannelKind(AcsMessageChannelKind channelKind) {
        this.channelKind = channelKind;
        return this;
    }

    @Override
    public AcsMessageDeliveryStatusUpdatedEventData setFrom(String from) {
        super.setFrom(from);
        return this;
    }

    @Override
    public AcsMessageDeliveryStatusUpdatedEventData setTo(String to) {
        super.setTo(to);
        return this;
    }

    @Override
    public AcsMessageDeliveryStatusUpdatedEventData setReceivedTimestamp(OffsetDateTime receivedTimestamp) {
        super.setReceivedTimestamp(receivedTimestamp);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("from", this.getFrom());
        jsonWriter.writeStringField("to", this.getTo());
        jsonWriter.writeStringField("receivedTimestamp", this.getReceivedTimestamp() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getReceivedTimestamp()));
        jsonWriter.writeJsonField("error", (JsonSerializable)this.getError());
        jsonWriter.writeStringField("messageId", this.messageId);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("channelType", this.channelKind == null ? null : this.channelKind.toString());
        return jsonWriter.writeEndObject();
    }

    public static AcsMessageDeliveryStatusUpdatedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsMessageDeliveryStatusUpdatedEventData)jsonReader.readObject(reader -> {
            AcsMessageDeliveryStatusUpdatedEventData deserializedAcsMessageDeliveryStatusUpdatedEventData = new AcsMessageDeliveryStatusUpdatedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("from".equals(fieldName)) {
                    deserializedAcsMessageDeliveryStatusUpdatedEventData.setFrom(reader.getString());
                    continue;
                }
                if ("to".equals(fieldName)) {
                    deserializedAcsMessageDeliveryStatusUpdatedEventData.setTo(reader.getString());
                    continue;
                }
                if ("receivedTimestamp".equals(fieldName)) {
                    deserializedAcsMessageDeliveryStatusUpdatedEventData.setReceivedTimestamp((OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString())));
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedAcsMessageDeliveryStatusUpdatedEventData.setError(AcsMessageChannelEventError.fromJson(reader));
                    continue;
                }
                if ("messageId".equals(fieldName)) {
                    deserializedAcsMessageDeliveryStatusUpdatedEventData.messageId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedAcsMessageDeliveryStatusUpdatedEventData.status = AcsMessageDeliveryStatus.fromString(reader.getString());
                    continue;
                }
                if ("channelType".equals(fieldName)) {
                    deserializedAcsMessageDeliveryStatusUpdatedEventData.channelKind = AcsMessageChannelKind.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsMessageDeliveryStatusUpdatedEventData;
        });
    }

    @Override
    public AcsMessageDeliveryStatusUpdatedEventData setError(ResponseError error) {
        super.setError(error);
        return this;
    }
}

