/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.models.ResponseError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.implementation.models.AcsRouterCommunicationError;
import com.azure.messaging.eventgrid.systemevents.AcsRouterJobEventData;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class AcsRouterJobClassificationFailedEventData
extends AcsRouterJobEventData {
    private String classificationPolicyId;
    private List<AcsRouterCommunicationError> errors;

    public String getClassificationPolicyId() {
        return this.classificationPolicyId;
    }

    public AcsRouterJobClassificationFailedEventData setClassificationPolicyId(String classificationPolicyId) {
        this.classificationPolicyId = classificationPolicyId;
        return this;
    }

    public List<ResponseError> getErrors() {
        return this.errors.stream().map(e -> new ResponseError(e.getCode(), e.getMessage())).collect(Collectors.toList());
    }

    public AcsRouterJobClassificationFailedEventData setErrors(List<ResponseError> errors) {
        this.errors = errors.stream().map(e -> new AcsRouterCommunicationError().setCode(e.getCode()).setMessage(e.getMessage())).collect(Collectors.toList());
        return this;
    }

    @Override
    public AcsRouterJobClassificationFailedEventData setQueueId(String queueId) {
        super.setQueueId(queueId);
        return this;
    }

    @Override
    public AcsRouterJobClassificationFailedEventData setLabels(Map<String, String> labels) {
        super.setLabels(labels);
        return this;
    }

    @Override
    public AcsRouterJobClassificationFailedEventData setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    @Override
    public AcsRouterJobClassificationFailedEventData setJobId(String jobId) {
        super.setJobId(jobId);
        return this;
    }

    @Override
    public AcsRouterJobClassificationFailedEventData setChannelReference(String channelReference) {
        super.setChannelReference(channelReference);
        return this;
    }

    @Override
    public AcsRouterJobClassificationFailedEventData setChannelId(String channelId) {
        super.setChannelId(channelId);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("jobId", this.getJobId());
        jsonWriter.writeStringField("channelReference", this.getChannelReference());
        jsonWriter.writeStringField("channelId", this.getChannelId());
        jsonWriter.writeStringField("queueId", this.getQueueId());
        jsonWriter.writeMapField("labels", this.getLabels(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("tags", this.getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("classificationPolicyId", this.classificationPolicyId);
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AcsRouterJobClassificationFailedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsRouterJobClassificationFailedEventData)jsonReader.readObject(reader -> {
            AcsRouterJobClassificationFailedEventData deserializedAcsRouterJobClassificationFailedEventData = new AcsRouterJobClassificationFailedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("jobId".equals(fieldName)) {
                    deserializedAcsRouterJobClassificationFailedEventData.setJobId(reader.getString());
                    continue;
                }
                if ("channelReference".equals(fieldName)) {
                    deserializedAcsRouterJobClassificationFailedEventData.setChannelReference(reader.getString());
                    continue;
                }
                if ("channelId".equals(fieldName)) {
                    deserializedAcsRouterJobClassificationFailedEventData.setChannelId(reader.getString());
                    continue;
                }
                if ("queueId".equals(fieldName)) {
                    deserializedAcsRouterJobClassificationFailedEventData.setQueueId(reader.getString());
                    continue;
                }
                if ("labels".equals(fieldName)) {
                    Map labels = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterJobClassificationFailedEventData.setLabels(labels);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterJobClassificationFailedEventData.setTags(tags);
                    continue;
                }
                if ("classificationPolicyId".equals(fieldName)) {
                    deserializedAcsRouterJobClassificationFailedEventData.classificationPolicyId = reader.getString();
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    List errors;
                    deserializedAcsRouterJobClassificationFailedEventData.errors = errors = reader.readArray(reader1 -> AcsRouterCommunicationError.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsRouterJobClassificationFailedEventData;
        });
    }
}

