// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;

import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/** The AcsChatMemberRemovedFromThreadWithUserEventData model. */
@Fluent
public final class AcsChatMemberRemovedFromThreadWithUserEventData extends AcsChatThreadEventBaseProperties {
    /*
     * The time at which the user was removed to the thread
     */
    private OffsetDateTime time;

    /*
     * The MRI of the user who removed the user
     */
    private String removedBy;

    /*
     * The details of the user who was removed
     */
    private AcsChatThreadMemberProperties memberRemoved;

    /**
     * Creates an instance of AcsChatMemberRemovedFromThreadWithUserEventData class
     */
    public AcsChatMemberRemovedFromThreadWithUserEventData() {

    }

    /**
     * Get the time property: The time at which the user was removed to the thread.
     *
     * @return the time value.
     */
    public OffsetDateTime getTime() {
        return this.time;
    }

    /**
     * Set the time property: The time at which the user was removed to the thread.
     *
     * @param time the time value to set.
     * @return the AcsChatMemberRemovedFromThreadWithUserEventData object itself.
     */
    public AcsChatMemberRemovedFromThreadWithUserEventData setTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    /**
     * Get the removedBy property: The MRI of the user who removed the user.
     *
     * @return the removedBy value.
     */
    public String getRemovedBy() {
        return this.removedBy;
    }

    /**
     * Set the removedBy property: The MRI of the user who removed the user.
     *
     * @param removedBy the removedBy value to set.
     * @return the AcsChatMemberRemovedFromThreadWithUserEventData object itself.
     */
    public AcsChatMemberRemovedFromThreadWithUserEventData setRemovedBy(String removedBy) {
        this.removedBy = removedBy;
        return this;
    }

    /**
     * Get the memberRemoved property: The details of the user who was removed.
     *
     * @return the memberRemoved value.
     */
    public AcsChatThreadMemberProperties getMemberRemoved() {
        return this.memberRemoved;
    }

    /**
     * Set the memberRemoved property: The details of the user who was removed.
     *
     * @param memberRemoved the memberRemoved value to set.
     * @return the AcsChatMemberRemovedFromThreadWithUserEventData object itself.
     */
    public AcsChatMemberRemovedFromThreadWithUserEventData
        setMemberRemoved(AcsChatThreadMemberProperties memberRemoved) {
        this.memberRemoved = memberRemoved;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("recipientCommunicationIdentifier", getRecipientCommunicationIdentifier());
        jsonWriter.writeStringField("transactionId", getTransactionId());
        jsonWriter.writeStringField("threadId", getThreadId());
        jsonWriter.writeStringField("createTime",
            this.getCreateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getCreateTime()));
        jsonWriter.writeNumberField("version", this.getVersion());
        jsonWriter.writeStringField("time",
            this.time == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.time));
        jsonWriter.writeStringField("removedBy", this.removedBy);
        jsonWriter.writeJsonField("memberRemoved", this.memberRemoved);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsChatThreadEventBaseProperties from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsChatThreadEventBaseProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcsChatThreadEventBaseProperties.
     */
    public static AcsChatMemberRemovedFromThreadWithUserEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsChatMemberRemovedFromThreadWithUserEventData acsChatMemberRemovedFromThreadWithUserEventData
                = new AcsChatMemberRemovedFromThreadWithUserEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("recipientCommunicationIdentifier".equals(fieldName)) {
                    acsChatMemberRemovedFromThreadWithUserEventData
                        .setRecipientCommunicationIdentifier(CommunicationIdentifierModel.fromJson(reader));
                } else if ("transactionId".equals(fieldName)) {
                    acsChatMemberRemovedFromThreadWithUserEventData.setTransactionId(reader.getString());
                } else if ("threadId".equals(fieldName)) {
                    acsChatMemberRemovedFromThreadWithUserEventData.setThreadId(reader.getString());
                } else if ("createTime".equals(fieldName)) {
                    acsChatMemberRemovedFromThreadWithUserEventData.setCreateTime(
                        reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString())));
                } else if ("version".equals(fieldName)) {
                    acsChatMemberRemovedFromThreadWithUserEventData.setVersion(reader.getNullable(JsonReader::getLong));
                } else if ("time".equals(fieldName)) {
                    acsChatMemberRemovedFromThreadWithUserEventData.time
                        = reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                } else if ("removedBy".equals(fieldName)) {
                    acsChatMemberRemovedFromThreadWithUserEventData.removedBy = reader.getString();
                } else if ("memberRemoved".equals(fieldName)) {
                    acsChatMemberRemovedFromThreadWithUserEventData.memberRemoved
                        = AcsChatThreadMemberProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return acsChatMemberRemovedFromThreadWithUserEventData;
        });
    }
}
