// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.ChatThreadParticipantAdded event.
 */
@Fluent
public final class AcsChatParticipantAddedToThreadEventData extends AcsChatEventInThreadBaseProperties {
    /*
     * The time at which the user was added to the thread
     */
    private OffsetDateTime time;

    /*
     * The communication identifier of the user who added the user
     */
    private CommunicationIdentifierModel addedByCommunicationIdentifier;

    /*
     * The details of the user who was added
     */
    private AcsChatThreadParticipantProperties participantAdded;

    /*
     * The version of the thread
     */
    private Long version;

    /**
     * Creates an instance of AcsChatParticipantAddedToThreadEventData class.
     */
    public AcsChatParticipantAddedToThreadEventData() {
    }

    /**
     * Get the time property: The time at which the user was added to the thread.
     * 
     * @return the time value.
     */
    public OffsetDateTime getTime() {
        return this.time;
    }

    /**
     * Set the time property: The time at which the user was added to the thread.
     * 
     * @param time the time value to set.
     * @return the AcsChatParticipantAddedToThreadEventData object itself.
     */
    public AcsChatParticipantAddedToThreadEventData setTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    /**
     * Get the addedByCommunicationIdentifier property: The communication identifier of the user who added the user.
     * 
     * @return the addedByCommunicationIdentifier value.
     */
    public CommunicationIdentifierModel getAddedByCommunicationIdentifier() {
        return this.addedByCommunicationIdentifier;
    }

    /**
     * Set the addedByCommunicationIdentifier property: The communication identifier of the user who added the user.
     * 
     * @param addedByCommunicationIdentifier the addedByCommunicationIdentifier value to set.
     * @return the AcsChatParticipantAddedToThreadEventData object itself.
     */
    public AcsChatParticipantAddedToThreadEventData
        setAddedByCommunicationIdentifier(CommunicationIdentifierModel addedByCommunicationIdentifier) {
        this.addedByCommunicationIdentifier = addedByCommunicationIdentifier;
        return this;
    }

    /**
     * Get the participantAdded property: The details of the user who was added.
     * 
     * @return the participantAdded value.
     */
    public AcsChatThreadParticipantProperties getParticipantAdded() {
        return this.participantAdded;
    }

    /**
     * Set the participantAdded property: The details of the user who was added.
     * 
     * @param participantAdded the participantAdded value to set.
     * @return the AcsChatParticipantAddedToThreadEventData object itself.
     */
    public AcsChatParticipantAddedToThreadEventData
        setParticipantAdded(AcsChatThreadParticipantProperties participantAdded) {
        this.participantAdded = participantAdded;
        return this;
    }

    /**
     * Get the version property: The version of the thread.
     * 
     * @return the version value.
     */
    public Long getVersion() {
        return this.version;
    }

    /**
     * Set the version property: The version of the thread.
     * 
     * @param version the version value to set.
     * @return the AcsChatParticipantAddedToThreadEventData object itself.
     */
    public AcsChatParticipantAddedToThreadEventData setVersion(Long version) {
        this.version = version;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatParticipantAddedToThreadEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatParticipantAddedToThreadEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("transactionId", getTransactionId());
        jsonWriter.writeStringField("threadId", getThreadId());
        jsonWriter.writeStringField("time",
            this.time == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.time));
        jsonWriter.writeJsonField("addedByCommunicationIdentifier", this.addedByCommunicationIdentifier);
        jsonWriter.writeJsonField("participantAdded", this.participantAdded);
        jsonWriter.writeNumberField("version", this.version);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsChatParticipantAddedToThreadEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsChatParticipantAddedToThreadEventData if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcsChatParticipantAddedToThreadEventData.
     */
    public static AcsChatParticipantAddedToThreadEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsChatParticipantAddedToThreadEventData deserializedAcsChatParticipantAddedToThreadEventData
                = new AcsChatParticipantAddedToThreadEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadEventData.setTransactionId(reader.getString());
                } else if ("threadId".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadEventData.setThreadId(reader.getString());
                } else if ("time".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadEventData.time = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("addedByCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadEventData.addedByCommunicationIdentifier
                        = CommunicationIdentifierModel.fromJson(reader);
                } else if ("participantAdded".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadEventData.participantAdded
                        = AcsChatThreadParticipantProperties.fromJson(reader);
                } else if ("version".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadEventData.version
                        = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcsChatParticipantAddedToThreadEventData;
        });
    }
}
