// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;

import java.io.IOException;

/** The AcsChatThreadMemberProperties model. */
@Fluent
public final class AcsChatThreadMemberProperties implements JsonSerializable<AcsChatThreadMemberProperties> {
    /*
     * The name of the user
     */
    private String displayName;

    /*
     * The MRI of the user
     */
    private String memberId;

    /**
     * Creates an instance of AcsChatThreadEventBaseProperties class
     */
    public AcsChatThreadMemberProperties() {

    }

    /**
     * Get the displayName property: The name of the user.
     *
     * @return the displayName value.
     */
    public String getDisplayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The name of the user.
     *
     * @param displayName the displayName value to set.
     * @return the AcsChatThreadMemberProperties object itself.
     */
    public AcsChatThreadMemberProperties setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the memberId property: The MRI of the user.
     *
     * @return the memberId value.
     */
    public String getMemberId() {
        return this.memberId;
    }

    /**
     * Set the memberId property: The MRI of the user.
     *
     * @param memberId the memberId value to set.
     * @return the AcsChatThreadMemberProperties object itself.
     */
    public AcsChatThreadMemberProperties setMemberId(String memberId) {
        this.memberId = memberId;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("memberId", this.memberId);
        jsonWriter.writeEndObject();
        return jsonWriter;
    }

    /**
     * Reads an instance of AcsChatThreadMemberProperties from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsChatThreadMemberProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcsChatThreadMemberProperties.
     */
    public static AcsChatThreadMemberProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsChatThreadMemberProperties acsChatThreadMemberProperties = new AcsChatThreadMemberProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayName".equals(fieldName)) {
                    acsChatThreadMemberProperties.setDisplayName(reader.getString());
                } else if ("memberId".equals(fieldName)) {
                    acsChatThreadMemberProperties.setMemberId(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return acsChatThreadMemberProperties;
        });
    }
}
