// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The identifier kind, for example 'communicationUser' or 'phoneNumber'.
 */
public final class AcsCommunicationIdentifierKind extends ExpandableStringEnum<AcsCommunicationIdentifierKind> {
    /**
     * Static value unknown for CommunicationIdentifierModelKind.
     */
    public static final AcsCommunicationIdentifierKind UNKNOWN = fromString("unknown");

    /**
     * Static value communicationUser for CommunicationIdentifierModelKind.
     */
    public static final AcsCommunicationIdentifierKind COMMUNICATION_USER = fromString("communicationUser");

    /**
     * Static value phoneNumber for CommunicationIdentifierModelKind.
     */
    public static final AcsCommunicationIdentifierKind PHONE_NUMBER = fromString("phoneNumber");

    /**
     * Static value microsoftTeamsUser for CommunicationIdentifierModelKind.
     */
    public static final AcsCommunicationIdentifierKind MICROSOFT_TEAMS_USER = fromString("microsoftTeamsUser");

    /**
     * Static value microsoftTeamsApp for CommunicationIdentifierModelKind.
     */
    public static final AcsCommunicationIdentifierKind MICROSOFT_TEAMS_APP = fromString("microsoftTeamsApp");

    /**
     * Creates a new instance of CommunicationIdentifierModelKind value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AcsCommunicationIdentifierKind() {
    }

    /**
     * Creates or finds a CommunicationIdentifierModelKind from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding CommunicationIdentifierModelKind.
     */
    public static AcsCommunicationIdentifierKind fromString(String name) {
        return fromString(name, AcsCommunicationIdentifierKind.class);
    }

    /**
     * Gets known CommunicationIdentifierModelKind values.
     * 
     * @return known CommunicationIdentifierModelKind values.
     */
    public static Collection<AcsCommunicationIdentifierKind> values() {
        return values(AcsCommunicationIdentifierKind.class);
    }
}
