// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The Message interactive reply type.
 */
public final class AcsInteractiveReplyKind extends ExpandableStringEnum<AcsInteractiveReplyKind> {
    /**
     * Messaged interactive reply type is ButtonReply.
     */
    public static final AcsInteractiveReplyKind BUTTON_REPLY = fromString("buttonReply");

    /**
     * Messaged interactive reply type is ListReply.
     */
    public static final AcsInteractiveReplyKind LIST_REPLY = fromString("listReply");

    /**
     * Messaged interactive reply type is Unknown.
     */
    public static final AcsInteractiveReplyKind UNKNOWN = fromString("unknown");

    /**
     * Creates a new instance of AcsInteractiveReplyKind value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AcsInteractiveReplyKind() {
    }

    /**
     * Creates or finds a AcsInteractiveReplyKind from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding AcsInteractiveReplyKind.
     */
    public static AcsInteractiveReplyKind fromString(String name) {
        return fromString(name, AcsInteractiveReplyKind.class);
    }

    /**
     * Gets known AcsInteractiveReplyKind values.
     * 
     * @return known AcsInteractiveReplyKind values.
     */
    public static Collection<AcsInteractiveReplyKind> values() {
        return values(AcsInteractiveReplyKind.class);
    }
}
