// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Message Button Content.
 */
@Fluent
public final class AcsMessageButtonContent implements JsonSerializable<AcsMessageButtonContent> {
    /*
     * The Text of the button
     */
    private String text;

    /*
     * The Payload of the button which was clicked by the user, setup by the business
     */
    private String payload;

    /**
     * Creates an instance of AcsMessageButtonContent class.
     */
    public AcsMessageButtonContent() {
    }

    /**
     * Get the text property: The Text of the button.
     * 
     * @return the text value.
     */
    public String getText() {
        return this.text;
    }

    /**
     * Set the text property: The Text of the button.
     * 
     * @param text the text value to set.
     * @return the AcsMessageButtonContent object itself.
     */
    public AcsMessageButtonContent setText(String text) {
        this.text = text;
        return this;
    }

    /**
     * Get the payload property: The Payload of the button which was clicked by the user, setup by the business.
     * 
     * @return the payload value.
     */
    public String getPayload() {
        return this.payload;
    }

    /**
     * Set the payload property: The Payload of the button which was clicked by the user, setup by the business.
     * 
     * @param payload the payload value to set.
     * @return the AcsMessageButtonContent object itself.
     */
    public AcsMessageButtonContent setPayload(String payload) {
        this.payload = payload;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("payload", this.payload);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsMessageButtonContent from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsMessageButtonContent if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcsMessageButtonContent.
     */
    public static AcsMessageButtonContent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsMessageButtonContent deserializedAcsMessageButtonContent = new AcsMessageButtonContent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("text".equals(fieldName)) {
                    deserializedAcsMessageButtonContent.text = reader.getString();
                } else if ("payload".equals(fieldName)) {
                    deserializedAcsMessageButtonContent.payload = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcsMessageButtonContent;
        });
    }
}
