// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Message Media Content.
 */
@Fluent
public final class AcsMessageMediaContent implements JsonSerializable<AcsMessageMediaContent> {
    /*
     * The MIME type of the file this media represents
     */
    private String mimeType;

    /*
     * The media identifier
     */
    private String mediaId;

    /*
     * The filename of the underlying media file as specified when uploaded
     */
    private String fileName;

    /*
     * The caption for the media object, if supported and provided
     */
    private String caption;

    /**
     * Creates an instance of AcsMessageMediaContent class.
     */
    public AcsMessageMediaContent() {
    }

    /**
     * Get the mimeType property: The MIME type of the file this media represents.
     * 
     * @return the mimeType value.
     */
    public String getMimeType() {
        return this.mimeType;
    }

    /**
     * Set the mimeType property: The MIME type of the file this media represents.
     * 
     * @param mimeType the mimeType value to set.
     * @return the AcsMessageMediaContent object itself.
     */
    public AcsMessageMediaContent setMimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    /**
     * Get the mediaId property: The media identifier.
     * 
     * @return the mediaId value.
     */
    public String getMediaId() {
        return this.mediaId;
    }

    /**
     * Set the mediaId property: The media identifier.
     * 
     * @param mediaId the mediaId value to set.
     * @return the AcsMessageMediaContent object itself.
     */
    public AcsMessageMediaContent setMediaId(String mediaId) {
        this.mediaId = mediaId;
        return this;
    }

    /**
     * Get the fileName property: The filename of the underlying media file as specified when uploaded.
     * 
     * @return the fileName value.
     */
    public String getFileName() {
        return this.fileName;
    }

    /**
     * Set the fileName property: The filename of the underlying media file as specified when uploaded.
     * 
     * @param fileName the fileName value to set.
     * @return the AcsMessageMediaContent object itself.
     */
    public AcsMessageMediaContent setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    /**
     * Get the caption property: The caption for the media object, if supported and provided.
     * 
     * @return the caption value.
     */
    public String getCaption() {
        return this.caption;
    }

    /**
     * Set the caption property: The caption for the media object, if supported and provided.
     * 
     * @param caption the caption value to set.
     * @return the AcsMessageMediaContent object itself.
     */
    public AcsMessageMediaContent setCaption(String caption) {
        this.caption = caption;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mimeType", this.mimeType);
        jsonWriter.writeStringField("id", this.mediaId);
        jsonWriter.writeStringField("fileName", this.fileName);
        jsonWriter.writeStringField("caption", this.caption);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsMessageMediaContent from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsMessageMediaContent if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcsMessageMediaContent.
     */
    public static AcsMessageMediaContent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsMessageMediaContent deserializedAcsMessageMediaContent = new AcsMessageMediaContent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("mimeType".equals(fieldName)) {
                    deserializedAcsMessageMediaContent.mimeType = reader.getString();
                } else if ("id".equals(fieldName)) {
                    deserializedAcsMessageMediaContent.mediaId = reader.getString();
                } else if ("fileName".equals(fieldName)) {
                    deserializedAcsMessageMediaContent.fileName = reader.getString();
                } else if ("caption".equals(fieldName)) {
                    deserializedAcsMessageMediaContent.caption = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcsMessageMediaContent;
        });
    }
}
