// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.RouterWorkerOfferExpired event.
 */
@Fluent
public final class AcsRouterWorkerOfferExpiredEventData extends AcsRouterWorkerEventData {
    /*
     * Router Worker Offer Expired Queue Id
     */
    private String queueId;

    /*
     * Router Worker Offer Expired Offer Id
     */
    private String offerId;

    /**
     * Creates an instance of AcsRouterWorkerOfferExpiredEventData class.
     */
    public AcsRouterWorkerOfferExpiredEventData() {
    }

    /**
     * Get the queueId property: Router Worker Offer Expired Queue Id.
     * 
     * @return the queueId value.
     */
    public String getQueueId() {
        return this.queueId;
    }

    /**
     * Set the queueId property: Router Worker Offer Expired Queue Id.
     * 
     * @param queueId the queueId value to set.
     * @return the AcsRouterWorkerOfferExpiredEventData object itself.
     */
    public AcsRouterWorkerOfferExpiredEventData setQueueId(String queueId) {
        this.queueId = queueId;
        return this;
    }

    /**
     * Get the offerId property: Router Worker Offer Expired Offer Id.
     * 
     * @return the offerId value.
     */
    public String getOfferId() {
        return this.offerId;
    }

    /**
     * Set the offerId property: Router Worker Offer Expired Offer Id.
     * 
     * @param offerId the offerId value to set.
     * @return the AcsRouterWorkerOfferExpiredEventData object itself.
     */
    public AcsRouterWorkerOfferExpiredEventData setOfferId(String offerId) {
        this.offerId = offerId;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsRouterWorkerOfferExpiredEventData setWorkerId(String workerId) {
        super.setWorkerId(workerId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsRouterWorkerOfferExpiredEventData setJobId(String jobId) {
        super.setJobId(jobId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsRouterWorkerOfferExpiredEventData setChannelReference(String channelReference) {
        super.setChannelReference(channelReference);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsRouterWorkerOfferExpiredEventData setChannelId(String channelId) {
        super.setChannelId(channelId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("jobId", getJobId());
        jsonWriter.writeStringField("channelReference", getChannelReference());
        jsonWriter.writeStringField("channelId", getChannelId());
        jsonWriter.writeStringField("workerId", getWorkerId());
        jsonWriter.writeStringField("queueId", this.queueId);
        jsonWriter.writeStringField("offerId", this.offerId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsRouterWorkerOfferExpiredEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsRouterWorkerOfferExpiredEventData if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcsRouterWorkerOfferExpiredEventData.
     */
    public static AcsRouterWorkerOfferExpiredEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsRouterWorkerOfferExpiredEventData deserializedAcsRouterWorkerOfferExpiredEventData
                = new AcsRouterWorkerOfferExpiredEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("jobId".equals(fieldName)) {
                    deserializedAcsRouterWorkerOfferExpiredEventData.setJobId(reader.getString());
                } else if ("channelReference".equals(fieldName)) {
                    deserializedAcsRouterWorkerOfferExpiredEventData.setChannelReference(reader.getString());
                } else if ("channelId".equals(fieldName)) {
                    deserializedAcsRouterWorkerOfferExpiredEventData.setChannelId(reader.getString());
                } else if ("workerId".equals(fieldName)) {
                    deserializedAcsRouterWorkerOfferExpiredEventData.setWorkerId(reader.getString());
                } else if ("queueId".equals(fieldName)) {
                    deserializedAcsRouterWorkerOfferExpiredEventData.queueId = reader.getString();
                } else if ("offerId".equals(fieldName)) {
                    deserializedAcsRouterWorkerOfferExpiredEventData.offerId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcsRouterWorkerOfferExpiredEventData;
        });
    }
}
