// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.AppConfiguration.SnapshotModified event.
 */
@Fluent
public final class AppConfigurationSnapshotModifiedEventData extends AppConfigurationSnapshotEventData {
    /**
     * Creates an instance of AppConfigurationSnapshotModifiedEventData class.
     */
    public AppConfigurationSnapshotModifiedEventData() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AppConfigurationSnapshotModifiedEventData setName(String name) {
        super.setName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AppConfigurationSnapshotModifiedEventData setEtag(String etag) {
        super.setEtag(etag);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AppConfigurationSnapshotModifiedEventData setSyncToken(String syncToken) {
        super.setSyncToken(syncToken);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("etag", getEtag());
        jsonWriter.writeStringField("syncToken", getSyncToken());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AppConfigurationSnapshotModifiedEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AppConfigurationSnapshotModifiedEventData if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AppConfigurationSnapshotModifiedEventData.
     */
    public static AppConfigurationSnapshotModifiedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AppConfigurationSnapshotModifiedEventData deserializedAppConfigurationSnapshotModifiedEventData
                = new AppConfigurationSnapshotModifiedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedAppConfigurationSnapshotModifiedEventData.setName(reader.getString());
                } else if ("etag".equals(fieldName)) {
                    deserializedAppConfigurationSnapshotModifiedEventData.setEtag(reader.getString());
                } else if ("syncToken".equals(fieldName)) {
                    deserializedAppConfigurationSnapshotModifiedEventData.setSyncToken(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAppConfigurationSnapshotModifiedEventData;
        });
    }
}
