// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A portion of the properties that can be written only by the application back-end, and read by the device.
 */
@Fluent
public final class DeviceTwinProperties implements JsonSerializable<DeviceTwinProperties> {
    /*
     * Metadata information for the properties JSON document.
     */
    private DeviceTwinMetadata metadata;

    /*
     * Version of device twin properties.
     */
    private Float version;

    /**
     * Creates an instance of DeviceTwinProperties class.
     */
    public DeviceTwinProperties() {
    }

    /**
     * Get the metadata property: Metadata information for the properties JSON document.
     * 
     * @return the metadata value.
     */
    public DeviceTwinMetadata getMetadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: Metadata information for the properties JSON document.
     * 
     * @param metadata the metadata value to set.
     * @return the DeviceTwinProperties object itself.
     */
    public DeviceTwinProperties setMetadata(DeviceTwinMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the version property: Version of device twin properties.
     * 
     * @return the version value.
     */
    public Float getVersion() {
        return this.version;
    }

    /**
     * Set the version property: Version of device twin properties.
     * 
     * @param version the version value to set.
     * @return the DeviceTwinProperties object itself.
     */
    public DeviceTwinProperties setVersion(Float version) {
        this.version = version;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("metadata", this.metadata);
        jsonWriter.writeNumberField("version", this.version);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeviceTwinProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeviceTwinProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeviceTwinProperties.
     */
    public static DeviceTwinProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeviceTwinProperties deserializedDeviceTwinProperties = new DeviceTwinProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("metadata".equals(fieldName)) {
                    deserializedDeviceTwinProperties.metadata = DeviceTwinMetadata.fromJson(reader);
                } else if ("version".equals(fieldName)) {
                    deserializedDeviceTwinProperties.version = reader.getNullable(JsonReader::getFloat);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeviceTwinProperties;
        });
    }
}
