// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Event data for Microsoft.Devices.DeviceDisconnected event.
 */
@Fluent
public final class IotHubDeviceDisconnectedEventData extends DeviceConnectionStateEventProperties {
    /**
     * Creates an instance of IotHubDeviceDisconnectedEventData class.
     */
    public IotHubDeviceDisconnectedEventData() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IotHubDeviceDisconnectedEventData setDeviceId(String deviceId) {
        super.setDeviceId(deviceId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IotHubDeviceDisconnectedEventData setModuleId(String moduleId) {
        super.setModuleId(moduleId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IotHubDeviceDisconnectedEventData setHubName(String hubName) {
        super.setHubName(hubName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IotHubDeviceDisconnectedEventData
        setDeviceConnectionStateEventInfo(DeviceConnectionStateEventInfo deviceConnectionStateEventInfo) {
        super.setDeviceConnectionStateEventInfo(deviceConnectionStateEventInfo);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("deviceId", getDeviceId());
        jsonWriter.writeStringField("moduleId", getModuleId());
        jsonWriter.writeStringField("hubName", getHubName());
        jsonWriter.writeJsonField("deviceConnectionStateEventInfo", getDeviceConnectionStateEventInfo());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IotHubDeviceDisconnectedEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IotHubDeviceDisconnectedEventData if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the IotHubDeviceDisconnectedEventData.
     */
    public static IotHubDeviceDisconnectedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IotHubDeviceDisconnectedEventData deserializedIotHubDeviceDisconnectedEventData
                = new IotHubDeviceDisconnectedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("deviceId".equals(fieldName)) {
                    deserializedIotHubDeviceDisconnectedEventData.setDeviceId(reader.getString());
                } else if ("moduleId".equals(fieldName)) {
                    deserializedIotHubDeviceDisconnectedEventData.setModuleId(reader.getString());
                } else if ("hubName".equals(fieldName)) {
                    deserializedIotHubDeviceDisconnectedEventData.setHubName(reader.getString());
                } else if ("deviceConnectionStateEventInfo".equals(fieldName)) {
                    deserializedIotHubDeviceDisconnectedEventData
                        .setDeviceConnectionStateEventInfo(DeviceConnectionStateEventInfo.fromJson(reader));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIotHubDeviceDisconnectedEventData;
        });
    }
}
