// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an EventGridEvent for a
 * Microsoft.ResourceNotifications.HealthResources.ResourceAnnotated event.
 */
@Fluent
public final class ResourceNotificationsHealthResourcesAnnotatedEventData
    extends ResourceNotificationsResourceUpdatedEventData {
    /**
     * Creates an instance of ResourceNotificationsHealthResourcesAnnotatedEventData class.
     */
    public ResourceNotificationsHealthResourcesAnnotatedEventData() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ResourceNotificationsHealthResourcesAnnotatedEventData
        setResourceDetails(ResourceNotificationsResourceUpdatedDetails resourceDetails) {
        super.setResourceDetails(resourceDetails);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ResourceNotificationsHealthResourcesAnnotatedEventData
        setOperationalDetails(ResourceNotificationsOperationalDetails operationalDetails) {
        super.setOperationalDetails(operationalDetails);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ResourceNotificationsHealthResourcesAnnotatedEventData setApiVersion(String apiVersion) {
        super.setApiVersion(apiVersion);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("resourceInfo", getResourceDetails());
        jsonWriter.writeJsonField("operationalInfo", getOperationalDetails());
        jsonWriter.writeStringField("apiVersion", getApiVersion());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceNotificationsHealthResourcesAnnotatedEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceNotificationsHealthResourcesAnnotatedEventData if the JsonReader was pointing to
     * an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceNotificationsHealthResourcesAnnotatedEventData.
     */
    public static ResourceNotificationsHealthResourcesAnnotatedEventData fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceNotificationsHealthResourcesAnnotatedEventData deserializedResourceNotificationsHealthResourcesAnnotatedEventData
                = new ResourceNotificationsHealthResourcesAnnotatedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resourceInfo".equals(fieldName)) {
                    deserializedResourceNotificationsHealthResourcesAnnotatedEventData
                        .setResourceDetails(ResourceNotificationsResourceUpdatedDetails.fromJson(reader));
                } else if ("operationalInfo".equals(fieldName)) {
                    deserializedResourceNotificationsHealthResourcesAnnotatedEventData
                        .setOperationalDetails(ResourceNotificationsOperationalDetails.fromJson(reader));
                } else if ("apiVersion".equals(fieldName)) {
                    deserializedResourceNotificationsHealthResourcesAnnotatedEventData
                        .setApiVersion(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceNotificationsHealthResourcesAnnotatedEventData;
        });
    }
}
