// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.ResourceNotifications.Resources.Deleted event.
 */
@Fluent
public final class ResourceNotificationsResourceManagementDeletedEventData
    extends ResourceNotificationsResourceDeletedEventData {
    /**
     * Creates an instance of ResourceNotificationsResourceManagementDeletedEventData class.
     */
    public ResourceNotificationsResourceManagementDeletedEventData() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ResourceNotificationsResourceManagementDeletedEventData
        setResourceDetails(ResourceNotificationsResourceDeletedDetails resourceDetails) {
        super.setResourceDetails(resourceDetails);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ResourceNotificationsResourceManagementDeletedEventData
        setOperationalDetails(ResourceNotificationsOperationalDetails operationalDetails) {
        super.setOperationalDetails(operationalDetails);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("resourceInfo", getResourceDetails());
        jsonWriter.writeJsonField("operationalInfo", getOperationalDetails());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceNotificationsResourceManagementDeletedEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceNotificationsResourceManagementDeletedEventData if the JsonReader was pointing to
     * an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceNotificationsResourceManagementDeletedEventData.
     */
    public static ResourceNotificationsResourceManagementDeletedEventData fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceNotificationsResourceManagementDeletedEventData deserializedResourceNotificationsResourceManagementDeletedEventData
                = new ResourceNotificationsResourceManagementDeletedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resourceInfo".equals(fieldName)) {
                    deserializedResourceNotificationsResourceManagementDeletedEventData
                        .setResourceDetails(ResourceNotificationsResourceDeletedDetails.fromJson(reader));
                } else if ("operationalInfo".equals(fieldName)) {
                    deserializedResourceNotificationsResourceManagementDeletedEventData
                        .setOperationalDetails(ResourceNotificationsOperationalDetails.fromJson(reader));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceNotificationsResourceManagementDeletedEventData;
        });
    }
}
