// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Storage.DirectoryDeleted event.
 */
@Fluent
public final class StorageDirectoryDeletedEventData implements JsonSerializable<StorageDirectoryDeletedEventData> {
    /*
     * The name of the API/operation that triggered this event.
     */
    private String api;

    /*
     * A request id provided by the client of the storage API operation that triggered this event.
     */
    private String clientRequestId;

    /*
     * The request id generated by the storage service for the storage API operation that triggered this event.
     */
    private String requestId;

    /*
     * The path to the deleted directory.
     */
    private String url;

    /*
     * Is this event for a recursive delete operation.
     */
    private String recursive;

    /*
     * An opaque string value representing the logical sequence of events for any particular directory name. Users can
     * use standard string comparison to understand the relative sequence of two events on the same directory name.
     */
    private String sequencer;

    /*
     * The identity of the requester that triggered this event.
     */
    private String identity;

    /*
     * For service use only. Diagnostic data occasionally included by the Azure Storage service. This property should be
     * ignored by event consumers.
     */
    private Object storageDiagnostics;

    /**
     * Creates an instance of StorageDirectoryDeletedEventData class.
     */
    public StorageDirectoryDeletedEventData() {
    }

    /**
     * Get the api property: The name of the API/operation that triggered this event.
     * 
     * @return the api value.
     */
    public String getApi() {
        return this.api;
    }

    /**
     * Set the api property: The name of the API/operation that triggered this event.
     * 
     * @param api the api value to set.
     * @return the StorageDirectoryDeletedEventData object itself.
     */
    public StorageDirectoryDeletedEventData setApi(String api) {
        this.api = api;
        return this;
    }

    /**
     * Get the clientRequestId property: A request id provided by the client of the storage API operation that triggered
     * this event.
     * 
     * @return the clientRequestId value.
     */
    public String getClientRequestId() {
        return this.clientRequestId;
    }

    /**
     * Set the clientRequestId property: A request id provided by the client of the storage API operation that triggered
     * this event.
     * 
     * @param clientRequestId the clientRequestId value to set.
     * @return the StorageDirectoryDeletedEventData object itself.
     */
    public StorageDirectoryDeletedEventData setClientRequestId(String clientRequestId) {
        this.clientRequestId = clientRequestId;
        return this;
    }

    /**
     * Get the requestId property: The request id generated by the storage service for the storage API operation that
     * triggered this event.
     * 
     * @return the requestId value.
     */
    public String getRequestId() {
        return this.requestId;
    }

    /**
     * Set the requestId property: The request id generated by the storage service for the storage API operation that
     * triggered this event.
     * 
     * @param requestId the requestId value to set.
     * @return the StorageDirectoryDeletedEventData object itself.
     */
    public StorageDirectoryDeletedEventData setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    /**
     * Get the url property: The path to the deleted directory.
     * 
     * @return the url value.
     */
    public String getUrl() {
        return this.url;
    }

    /**
     * Set the url property: The path to the deleted directory.
     * 
     * @param url the url value to set.
     * @return the StorageDirectoryDeletedEventData object itself.
     */
    public StorageDirectoryDeletedEventData setUrl(String url) {
        this.url = url;
        return this;
    }

    /**
     * Get the recursive property: Is this event for a recursive delete operation.
     * 
     * @return the recursive value.
     */
    public Boolean isRecursive() {
        String returnValue = this.recursive;
        return Boolean.getBoolean(returnValue);
    }

    /**
     * Set the recursive property: Is this event for a recursive delete operation.
     * 
     * @param recursive the recursive value to set.
     * @return the StorageDirectoryDeletedEventData object itself.
     */
    public StorageDirectoryDeletedEventData setRecursive(Boolean recursive) {
        this.recursive = String.valueOf(recursive);
        return this;
    }

    /**
     * Get the sequencer property: An opaque string value representing the logical sequence of events for any particular
     * directory name. Users can use standard string comparison to understand the relative sequence of two events on the
     * same directory name.
     * 
     * @return the sequencer value.
     */
    public String getSequencer() {
        return this.sequencer;
    }

    /**
     * Set the sequencer property: An opaque string value representing the logical sequence of events for any particular
     * directory name. Users can use standard string comparison to understand the relative sequence of two events on the
     * same directory name.
     * 
     * @param sequencer the sequencer value to set.
     * @return the StorageDirectoryDeletedEventData object itself.
     */
    public StorageDirectoryDeletedEventData setSequencer(String sequencer) {
        this.sequencer = sequencer;
        return this;
    }

    /**
     * Get the identity property: The identity of the requester that triggered this event.
     * 
     * @return the identity value.
     */
    public String getIdentity() {
        return this.identity;
    }

    /**
     * Set the identity property: The identity of the requester that triggered this event.
     * 
     * @param identity the identity value to set.
     * @return the StorageDirectoryDeletedEventData object itself.
     */
    public StorageDirectoryDeletedEventData setIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the storageDiagnostics property: For service use only. Diagnostic data occasionally included by the Azure
     * Storage service. This property should be ignored by event consumers.
     * 
     * @return the storageDiagnostics value.
     */
    public Object getStorageDiagnostics() {
        return this.storageDiagnostics;
    }

    /**
     * Set the storageDiagnostics property: For service use only. Diagnostic data occasionally included by the Azure
     * Storage service. This property should be ignored by event consumers.
     * 
     * @param storageDiagnostics the storageDiagnostics value to set.
     * @return the StorageDirectoryDeletedEventData object itself.
     */
    public StorageDirectoryDeletedEventData setStorageDiagnostics(Object storageDiagnostics) {
        this.storageDiagnostics = storageDiagnostics;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("api", this.api);
        jsonWriter.writeStringField("clientRequestId", this.clientRequestId);
        jsonWriter.writeStringField("requestId", this.requestId);
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("recursive", this.recursive);
        jsonWriter.writeStringField("sequencer", this.sequencer);
        jsonWriter.writeStringField("identity", this.identity);
        jsonWriter.writeUntypedField("storageDiagnostics", this.storageDiagnostics);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageDirectoryDeletedEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageDirectoryDeletedEventData if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StorageDirectoryDeletedEventData.
     */
    public static StorageDirectoryDeletedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageDirectoryDeletedEventData deserializedStorageDirectoryDeletedEventData
                = new StorageDirectoryDeletedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("api".equals(fieldName)) {
                    deserializedStorageDirectoryDeletedEventData.api = reader.getString();
                } else if ("clientRequestId".equals(fieldName)) {
                    deserializedStorageDirectoryDeletedEventData.clientRequestId = reader.getString();
                } else if ("requestId".equals(fieldName)) {
                    deserializedStorageDirectoryDeletedEventData.requestId = reader.getString();
                } else if ("url".equals(fieldName)) {
                    deserializedStorageDirectoryDeletedEventData.url = reader.getString();
                } else if ("recursive".equals(fieldName)) {
                    deserializedStorageDirectoryDeletedEventData.recursive = reader.getString();
                } else if ("sequencer".equals(fieldName)) {
                    deserializedStorageDirectoryDeletedEventData.sequencer = reader.getString();
                } else if ("identity".equals(fieldName)) {
                    deserializedStorageDirectoryDeletedEventData.identity = reader.getString();
                } else if ("storageDiagnostics".equals(fieldName)) {
                    deserializedStorageDirectoryDeletedEventData.storageDiagnostics = reader.readUntyped();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStorageDirectoryDeletedEventData;
        });
    }
}
