/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.StorageBlobAccessTier;
import java.io.IOException;

public final class StorageBlobCreatedEventData
implements JsonSerializable<StorageBlobCreatedEventData> {
    private String api;
    private String clientRequestId;
    private String requestId;
    private String eTag;
    private String contentType;
    private Long contentLength;
    private Long contentOffset;
    private String blobType;
    private StorageBlobAccessTier accessTier;
    private String url;
    private String sequencer;
    private String identity;
    private Object storageDiagnostics;

    public String getApi() {
        return this.api;
    }

    public StorageBlobCreatedEventData setApi(String api) {
        this.api = api;
        return this;
    }

    public String getClientRequestId() {
        return this.clientRequestId;
    }

    public StorageBlobCreatedEventData setClientRequestId(String clientRequestId) {
        this.clientRequestId = clientRequestId;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public StorageBlobCreatedEventData setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public StorageBlobCreatedEventData setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public StorageBlobCreatedEventData setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public StorageBlobCreatedEventData setContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public Long getContentOffset() {
        return this.contentOffset;
    }

    public StorageBlobCreatedEventData setContentOffset(Long contentOffset) {
        this.contentOffset = contentOffset;
        return this;
    }

    public String getBlobType() {
        return this.blobType;
    }

    public StorageBlobCreatedEventData setBlobType(String blobType) {
        this.blobType = blobType;
        return this;
    }

    public StorageBlobAccessTier getAccessTier() {
        return this.accessTier;
    }

    public StorageBlobCreatedEventData setAccessTier(StorageBlobAccessTier accessTier) {
        this.accessTier = accessTier;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public StorageBlobCreatedEventData setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getSequencer() {
        return this.sequencer;
    }

    public StorageBlobCreatedEventData setSequencer(String sequencer) {
        this.sequencer = sequencer;
        return this;
    }

    public String getIdentity() {
        return this.identity;
    }

    public StorageBlobCreatedEventData setIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    public Object getStorageDiagnostics() {
        return this.storageDiagnostics;
    }

    public StorageBlobCreatedEventData setStorageDiagnostics(Object storageDiagnostics) {
        this.storageDiagnostics = storageDiagnostics;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("accessTier", this.accessTier == null ? null : this.accessTier.toString());
        jsonWriter.writeStringField("api", this.api);
        jsonWriter.writeStringField("clientRequestId", this.clientRequestId);
        jsonWriter.writeStringField("requestId", this.requestId);
        jsonWriter.writeStringField("eTag", this.eTag);
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeNumberField("contentLength", (Number)this.contentLength);
        jsonWriter.writeNumberField("contentOffset", (Number)this.contentOffset);
        jsonWriter.writeStringField("blobType", this.blobType);
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("sequencer", this.sequencer);
        jsonWriter.writeStringField("identity", this.identity);
        jsonWriter.writeUntypedField("storageDiagnostics", this.storageDiagnostics);
        return jsonWriter.writeEndObject();
    }

    public static StorageBlobCreatedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (StorageBlobCreatedEventData)jsonReader.readObject(reader -> {
            StorageBlobCreatedEventData deserializedStorageBlobCreatedEventData = new StorageBlobCreatedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accessTier".equals(fieldName)) {
                    deserializedStorageBlobCreatedEventData.accessTier = StorageBlobAccessTier.fromString(reader.getString());
                    continue;
                }
                if ("api".equals(fieldName)) {
                    deserializedStorageBlobCreatedEventData.api = reader.getString();
                    continue;
                }
                if ("clientRequestId".equals(fieldName)) {
                    deserializedStorageBlobCreatedEventData.clientRequestId = reader.getString();
                    continue;
                }
                if ("requestId".equals(fieldName)) {
                    deserializedStorageBlobCreatedEventData.requestId = reader.getString();
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedStorageBlobCreatedEventData.eTag = reader.getString();
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    deserializedStorageBlobCreatedEventData.contentType = reader.getString();
                    continue;
                }
                if ("contentLength".equals(fieldName)) {
                    deserializedStorageBlobCreatedEventData.contentLength = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("contentOffset".equals(fieldName)) {
                    deserializedStorageBlobCreatedEventData.contentOffset = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("blobType".equals(fieldName)) {
                    deserializedStorageBlobCreatedEventData.blobType = reader.getString();
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedStorageBlobCreatedEventData.url = reader.getString();
                    continue;
                }
                if ("sequencer".equals(fieldName)) {
                    deserializedStorageBlobCreatedEventData.sequencer = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedStorageBlobCreatedEventData.identity = reader.getString();
                    continue;
                }
                if ("storageDiagnostics".equals(fieldName)) {
                    deserializedStorageBlobCreatedEventData.storageDiagnostics = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageBlobCreatedEventData;
        });
    }
}

