/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.CommunicationIdentifierModel;
import java.io.IOException;
import java.util.Map;

public final class AcsChatThreadParticipantProperties
implements JsonSerializable<AcsChatThreadParticipantProperties> {
    private String displayName;
    private CommunicationIdentifierModel participantCommunicationIdentifier;
    private Map<String, String> metadata;

    public String getDisplayName() {
        return this.displayName;
    }

    public AcsChatThreadParticipantProperties setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public CommunicationIdentifierModel getParticipantCommunicationIdentifier() {
        return this.participantCommunicationIdentifier;
    }

    public AcsChatThreadParticipantProperties setParticipantCommunicationIdentifier(CommunicationIdentifierModel participantCommunicationIdentifier) {
        this.participantCommunicationIdentifier = participantCommunicationIdentifier;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public AcsChatThreadParticipantProperties setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeJsonField("participantCommunicationIdentifier", (JsonSerializable)this.participantCommunicationIdentifier);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static AcsChatThreadParticipantProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AcsChatThreadParticipantProperties)jsonReader.readObject(reader -> {
            AcsChatThreadParticipantProperties deserializedAcsChatThreadParticipantProperties = new AcsChatThreadParticipantProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayName".equals(fieldName)) {
                    deserializedAcsChatThreadParticipantProperties.displayName = reader.getString();
                    continue;
                }
                if ("participantCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatThreadParticipantProperties.participantCommunicationIdentifier = CommunicationIdentifierModel.fromJson(reader);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedAcsChatThreadParticipantProperties.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsChatThreadParticipantProperties;
        });
    }
}

